pro fuv_mission_correction,year,day,correction,all=all
;
; program to correct the raw counts of FUV instruments for temperature
; and high voltage effects
; data are read from file summary_2001_001.txt which was produced with
; the routine check_stars_all
;
; Harald Frey
; September 12, 2001
; Modified: April 16, 2002	hfrey
;				included keyword all and made smoothing
;           August 11, 2002	hfrey
;				make faster with save/restore
;
; Output correction comes as WIC, SI12, SI13
;

	; restore data file
;restore,'$FUVIEW_HOME/support/fuv_mission_correction.sav'
dir_sep=path_sep()
restore,getenv('FUVIEW_HOME')+dir_sep+'support'+dir_sep+'fuv_mission_correction.sav'

	; now the final step, find the right correction
dummy=where(day eq newday and year eq newyear,count)
correction=fltarr(3)
if (count eq 1) then begin
  correction[1]=finals12[171]/finals12[dummy]
  correction[2]=finals13[171]/finals13[dummy]
  correction[0]=finalwic[171]/finalwic[dummy]
  endif else correction=fltarr(3)+1.0
  
if keyword_set(all) then begin
  all=[[newyear],[newday],[finalwic],[finals12],[finals13]]
  endif

end

pro fuv_mission_correction_establish,year,day,correction,all=all
;
; program to correct the raw counts of FUV instruments for temperature
; and high voltage effects
; data are read from file summary_2001_001.txt which was produced with
; the routine check_stars_all
;
; Harald Frey
; September 12, 2001
; Modified: April 16, 2002	hfrey
;				included keyword all and made smoothing
;
; Output correction comes as WIC, SI12, SI13
;

	; initialize a few variables
dummy=' '
dats=fltarr(19)
data=fltarr(26,1000)	; 3000 elements to start with
position=0
i=0
ersti=0

	; read in data from file
	; we have to make a trick with the file format, point back and forth in file
openr,unit,getenv('FUVIEW_HOME')+dir_sep+'support'+dir_sep+'fuview_stars_2002_2.txt',/get_lun
;openr,unit,'$FUVIEW_HOME/support/fuview_stars_2002_2.txt',/get_lun
;openr,unit,'~hfrey/idl/image/fuview/fuview_stars.new',/get_lun		; delta crux
;openr,unit,'~hfrey/idl/image/fuview/fuview_new_star.txt',/get_lun	; alpha musca
;openr,unit,'~hfrey/idl/image/fuview/alpha_eridani.txt',/get_lun	; alpha eridani

while not eof(unit) do begin
 nochmal:
  point_lun,-unit,position
  readf,unit,dummy,format='(a10)'
  if (dummy eq 'check_star') then goto,nochmal else begin
    point_lun,unit,position
    readf,unit,dats
    if (dats[0] gt 1900) then begin
      if (i ge n_elements(data[0,*])) then data=[[data],[data]]  ; extent array
      data[0:18,i]=dats
      i=i+1
      endif else begin
      for ppp=ersti,i-1 do data[7:*,ppp]=dats
      ersti=i
      endelse
    endelse
    
endwhile
free_lun,unit

	; eliminate all douplicate and zero-data
data=data[*,0:i-1]
dumnumb=where(data[4,*] eq 0.)
data[4,dumnumb]=!values.f_nan
dumnumb=where(data[5,*] eq 0.)
data[5,dumnumb]=!values.f_nan
dumnumb=where(data[6,*] eq 0.)
data[6,dumnumb]=!values.f_nan

	; check time range that is covered
first_day=data[1,0]
last_year=data[0,i-1]
last_day=data[1,i-1]

	; construct time line
timeline=(data[0,*]-2000)*366.+data[1,*]+data[2,*]/24.+data[3,*]/24./60.
case last_year of
2000: wait,0.1	; everything is fine
2001: wait,0.1	; everything is fine
2002: begin	; correct for 366 days in 2000
	dummy=where(data[0,*] eq 2002,count)
	if (count gt 0) then timeline[dummy]=timeline[dummy]-1
	endcase
2003: begin	; correct for 366 days in 2000
	dummy=where(data[0,*] eq 2002,count)
	if (count gt 0) then timeline[dummy]=timeline[dummy]-1
	dummy=where(data[0,*] eq 2003,count)
	if (count gt 0) then timeline[dummy]=timeline[dummy]-1
	endcase
ELSE: begin
	print,'fuv_mission_correction does not cover this year'
	print,'Check with whoever is in charge!'
	stop
	endcase
endcase

	; construct the correction files
number_of_days=round(max(timeline))+1
newtime=findgen(number_of_days)
newyear=fltarr(number_of_days)+!values.f_nan
newday=fltarr(number_of_days)+!values.f_nan
case 1 of
(number_of_days le 366): begin				; 2000
	newyear[0:number_of_days-1]=2000
	newday[0:number_of_days-1]=findgen(number_of_days)
	endcase
(number_of_days le 366+365): begin			; 2001
	newyear[0:366]=2000
	newyear[367:number_of_days-1]=2001
	newday[0:366]=findgen(367)
	newday[367:number_of_days-1]=findgen(number_of_days-367)+1	;doy=1 not zero
	endcase
(number_of_days le 366+365+365): begin			; 2002
	newyear[0:366]=2000
	newyear[367:366+365]=2001
	newyear[366+365+1:number_of_days-1]=2002
	newday[0:366]=findgen(367)
	newday[367:367+365]=findgen(366)+1					;doy=1 not zero
	newday[367+365:number_of_days-1]=findgen(number_of_days-367-365)+1	;doy=1 not zero
	endcase
(number_of_days le 366+365+365+365): begin			; 2003
	print,'fuv_mission_correction does not cover this year'
	print,'Check with whoever is in charge!'
	stop
	endcase
	endcase
newwic=fltarr(number_of_days)+!values.f_nan
news12=fltarr(number_of_days)+!values.f_nan
news13=fltarr(number_of_days)+!values.f_nan
for i=fix(min(timeline)),round(max(timeline)) do begin
   dummy=where(round(timeline) eq i,count)
   if (count gt 0) then begin
     newwic[i]=median(data[4,dummy])
     news12[i]=median(data[5,dummy])
     news13[i]=median(data[6,dummy])
     endif
   endfor
good=where(newwic eq newwic)
newwic[0]=newwic[good[0]]   
good=where(news12 eq news12)
news12[0]=news12[good[0]]   
good=where(news13 eq news13)
news13[0]=news13[good[0]]   

	; now fill all gaps without star observations
	; WIC
dummy1=where(newwic ne newwic)
dummy2=where(newwic eq newwic)
finalwic=newwic
finalwic[dummy2]=finalwic[dummy2]
finalwic[dummy1]=interpol(newwic[dummy2],newtime[dummy2],dummy1)
 	; SI12
dummy1=where(news12 ne news12)
dummy2=where(news12 eq news12)
finals12=news12
finals12[dummy2]=finals12[dummy2]
finals12[dummy1]=interpol(news12[dummy2],newtime[dummy2],dummy1)
	; SI13
dummy1=where(news13 ne news13)
dummy2=where(news13 eq news13)
finals13=news13
finals13[dummy2]=finals13[dummy2]
finals13[dummy1]=interpol(news13[dummy2],newtime[dummy2],dummy1)

	; these are the hard-wired changes according to operational issues in the orbit
	; turn off of HV during integration
finalwic[276:328]=interpol([newwic[275],newwic[329]],[newtime[275],newtime[329]],findgen(55-2)+276)
finals12[297:319]=interpol([news12[296],news12[320]],[newtime[296],newtime[320]],findgen(25-2)+297)
finals13[297:319]=interpol([news13[296],news13[320]],[newtime[296],newtime[320]],findgen(25-2)+297)
	; turn off of HV during integration
finalwic[607:703]=interpol([newwic[606],newwic[704]],[newtime[606],newtime[704]],findgen(97)+607)
finals12[618:703]=interpol([news12[617],news12[704]],[newtime[617],newtime[704]],findgen(86)+618)
finals13[638:709]=interpol([news13[637],news13[710]],[newtime[637],newtime[710]],findgen(72)+638)
	; SI-13 hits the less sensitive part
;finals13[761:779]=interpol([news13[760],news13[780]],[newtime[760],newtime[780]],findgen(19)+761)

	; now a little bit smoothing, but not with smooth, but rather with median
finalwic=median(finalwic,5)
finals12=median(finals12,5)
finals13=median(finals13,5)

	; now the final step, find the right correction
dummy=where(day eq newday and year eq newyear,count)
correction=fltarr(3)
if (count eq 1) then begin
  correction[1]=finals12[171]/finals12[dummy]
  correction[2]=finals13[171]/finals13[dummy]
  correction[0]=finalwic[171]/finalwic[dummy]
  endif else correction=fltarr(3)+1.0
  
if keyword_set(all) then begin
  all=[[newyear],[newday],[finalwic],[finals12],[finals13]]
  endif

stop
end
