PRO fuv_calc_pointing, inst, posX, posY, posZ, sysrec
;
;------------------------------------------------------------------------------------
; This the latest version of GIFWALK program.  Applying the FUV modification to it
;
;Modified:
;
; Hassan Dougani	10/04/1999  Applying the latest FUV modifications
; Hassan Dougani	10/28/1999  Modify structures for multiple Instrument capability
; Harald Frey           01/05/2000  modify pointing calculation for FUV
;
;------------------------------------------------------------------------------------
;
@fuv_cmnblk
;
    ;Calculate time vector
    time=LONARR(2)


    read_epoch, ImageInfo(inst).epoch, year, month, day, hr, min, sec $
              , ms, ut, doy
    time(0) = 1000*year + doy
    time(1) = hr*60*60*1000 + $
              min*60*1000 + $
              sec*1000 + $
              ms

;
;	if (cor eq 1) then return
    ;Get pixel pointing
    ;
    if (gci_flag eq 0) then fuv_ptg,ImageInfo(inst), time, $
         emis_hgt, glat, glon, l0, ras, decl, $
         posX=posX, posY=posY, posZ=posZ, /geodetic,earthlat=earthlat,earthlon=earthlon $
    else $
		 fuv_ptg,ImageInfo(inst), time, $
         emis_hgt, glat, glon, l0, ras, decl, $
         posX=posX, posY=posY, posZ=posZ,earthlat=earthlat,earthlon=earthlon


    ;Save the look direction

    ImageInfo(inst).time = time
    ImageInfo(inst).l0 = l0
    ImageInfo(inst).ra = ras
    ImageInfo(inst).dec = decl

;    ImageInfo(inst).lat_ctr = glat( (ImageInfo(inst).cols/2)-1, (ImageInfo(inst).rows/2)-1 )
;    ImageInfo(inst).lon_ctr = glon( (ImageInfo(inst).cols/2)-1, (ImageInfo(inst).rows/2)-1 )
    ImageInfo(inst).lat_ctr = earthlat
    ImageInfo(inst).lon_ctr = earthlon
    ImageInfo(inst).glat=glat
    ImageINfo(inst).glon=glon

;	if (cor eq 1) then return

    ; Get magnetic latitudes and longitudes
    geo_to_apex, glat, glon, mlat, mlon, apxfile
    ImageInfo(inst).mlat=mlat
    ImageInfo(inst).mlon=mlon
    ImageInfo(inst).sza=sza_arr
    ImageInfo(inst).dza=dza_arr

    ; Get magnetic local time
    get_lt, ut, year, month, day, glat, glon, apxfile, glt, mlt
    ImageInfo(inst).mlt=mlt
    dummy=where(glat lt -1.e30,count)
    if (count gt 0) then begin
       ImageInfo(inst).mlat[dummy]=-sphere*1.e31
       ImageInfo(inst).mlon[dummy]=-sphere*1.e31
       ImageInfo(inst).mlt[dummy]=-sphere*1.e31
       endif
;
;flag to update mlt image
	mlt_rdy=0
;
END

