;
FUNCTION Calculate_scaling,image,inst
;
@fuv_cmnblk
;
;
   ImageInfo(inst).minval=min(ImageInfo(inst).image)
   ImageInfo(inst).maxval=max(ImageInfo(inst).image)
   tmp=MOMENT(ImageInfo(inst).image,SDEV=ImageInfo(inst).std)
   ImageInfo(inst).mean=tmp(0)

  if (scale_type eq 0 ) then begin
    minval=log_scl_min
    maxval=log_scl_max
;    maxval=((imageinfo(inst).maxval/10)+1)*10
;
    pre_scl = 1./log_scl_min                     ; to avoid negative values
    post_scl = $
         top_color/ALOG10(log_scl_max*pre_scl)   ; to match color table
;         getpen("white")/ALOG(ImageInfo.max*pre_scl)   ; to match color table
    tmp_img = pre_scl*image
    tmp_img = ((ALOG10(tmp_img>0.0001)>0.0001)*post_scl)<top_color
   endif else begin
     tmp_img=(top_color*(((image-lin_scl_min)>0)/(lin_scl_max-lin_scl_min)))<top_color
   endelse
    RETURN,tmp_img
;
end
; @(#)display_img.pro	1.2 08/25/99
; Create a composite image and display on screen. Borrowed Most part of this routine from Mkgif.pro.
;
; The 600x420 screen area is divided as follows:
;
;   --------------------------------------- 419
;   |                | C |                |
;   |   Geodetic     | o | Geomagnetic    |
;   |    Image       | l |    Image       |
;   |                | o |                |
;   |                | r |                |
;   |                | b |                |
;   |                | a |                |
;   |                | r |                |
;   |-------------------------------------|
;   |            Altitude Plot            |
;   |-------------------------------------|
;   |            Housekeeping             |
;   --------------------------------------   0
;   0                                    599
;  This procedure is replacement of original MkGif procedure. Added common blocks for widgets, Color table, Coordinate
;  option( Cor = 0 for whole, Cor=1 for Geodetic, Cor =2 for MLT(apex). (K. Majumdar 06-99)
; Added code to resize the screen.
; Added Z-buffer option
;
;------------------------------------------------------------------------------------
; This the latest version of GIFWALK program.  Applying the FUV modification to it
;
;Modified:
;
; Hassan Dougani	10/04/1999			Applying the latest FUV modifications
; Hassan Dougani	10/28/1999			Modify structures for multiple Instrument capability
;
;------------------------------------------------------------------------------------
;

FUNCTION display_img, inst,record,rfresh=RFRESH
;
@fuv_cmnblk
forward_function get_fname
;
   strMonth=['Jan','Feb','Mar','Apr','May','Jun', $
              'Jul','Aug','Sep','Oct','Nov','Dec']

   images_limits=fltarr(3,4)
 ;
   erase, bkgrnd
   frec = where(record eq recnum)

   if (KEYWORD_SET(RFRESH) and mlt_rdy eq 1) then rfresh=1 else rfresh=0


   gifSizeX = xwin
   gifSizeY = ywin
   border = 5
    ; Define the limits of each region
    ;

    ; Let the image regions have 45% each in the X direction
    ; and 65% in the Y direction.
    ImgXsize = 270
    ImgYsize = nypix


    CbarXsize = 60
    CbarYsize = ImgYsize

    ; Give the altitude region 60% and the housekeeping region 40%
    ; of the remaining area.
    AltXsize = gifSizeX
    HskXsize = AltXsize
    HskYsize = 60
    AltYsize = 30

    ; Define the coordinates of the end points of a diagonal from lower left
    ; to upper right of the position and size of each region.
    ;

    ; Altitude
    llx = 5
    lly = 15
    urx = AltXsize - 1
    ury = lly + AltYsize - 1
    AltLimits = [llx, lly, urx, ury]

    ; Housekeeping
    llx = 10
    lly = AltLimits[3]+20
    urx = HskXsize - 1
    ury = lly+ HskYsize - 1
    HskLimits = [llx, lly, urx, ury]

    ;  images
     l_image_align=7
     r_image_align=0
     urx=0
     lly = HskLimits[3]+4
     ury = lly+ ImgYsize - 1
     xs=255
    y_limit_low=ury-nypix+1
    x_limit_low=image_align
    for i=0, multi_inst-1 do begin
     llx = l_image_align+urx+r_image_align
     urx = llx+xs
     r_image_align=7
     images_limits(i,*) = [llx, lly, urx, ury]
    endfor
    if (cor eq 0) then begin
     llx = l_image_align+urx+r_image_align
     urx = llx+xs
     r_image_align=7
     images_limits(1,*) = [llx, lly, urx, ury]
    endif
;
    ; Color bar
    llx = gifSizeX-80
    lly = HskYsize + AltYsize+10
    urx = llx+ CbarXsize - 1
    ury = lly + CbarYsize - 1
    CbarLimits = [llx, lly, urx, ury]

    ; Insert a title

    cdf_epoch, ImageInfo(inst).epoch, year, month, day, hour, minute, second, $
        /BREAKDOWN_EPOCH
    cur_win = !D.WINDOW
    case cor of
     0: begin
        char_size=1.5
        strTitle = STRING( $
        FORMAT=$
		'("   ",I2.2," ",A3," ",I4.4,"     ",I2.2,":",I2.2,":",I2.2," UT")' $
               ,day,strMonth(month-1), year, hour, minute, second)
        xpos = (gifSizeX / 2)
        ypos = gifSizeY - 14 * char_size
        xpos = float(xpos)/float(xwin)
        ypos = float(ypos)/float(ywin)
        xyouts, xpos, ypos, 'FUV Imager/'+ImageInfo(inst).Inst_id+strTitle, /NORMAL, ALIGNMENT=0.5 $
          ,CHARSIZE=char_size,COLOR= txt_clr
        end
     1: begin
       strTitle1 = STRING( $
        FORMAT=$
		'("   ",I2.2," ",A3," ",I4.4)' ,day,strMonth(month-1), year)

        strTitle2 = STRING( $
                    FORMAT='(I2.2,":",I2.2,":",I2.2," UT")',  $
                             hour, minute, second)
        if (multi_inst gt 1) then begin
          ch_size=1.5
          stitle1 = 'FUV Imagers'+strTitle1
        endif else begin
          ch_size=1.5
          stitle1 = 'FUV Imagers/'+ImageInfo(inst).Inst_id+strTitle1
        endelse
        xpos = gifSizeX / 2
        ypos = gifSizeY - 12 * ch_size
        ypos1 = gifSizeY - 25 * ch_size
        xpos = float(xpos)/float(xwin)
        ypos = float(ypos)/float(ywin)
        ypos1 = float(ypos1)/float(ywin)
        xyouts, xpos, ypos, stitle1, /NORMAL, ALIGNMENT=0.5 $
          ,CHARSIZE=ch_size,COLOR= txt_clr
        xyouts, xpos, ypos1, strTitle2, /NORMAL, ALIGNMENT=0.5 $
          ,CHARSIZE=ch_size,COLOR= txt_clr
       end
     2: begin
        strTitle1 = STRING( $
        FORMAT=$
			'("   ",I2.2," ",A3," ",I4.4)' ,day,strMonth(month-1), year )

        strTitle2 = STRING( $
                    FORMAT='(I2.2,":",I2.2,":",I2.2," UT")', $
                             hour, minute, second)
        if (multi_inst gt 1) then begin
          ch_size=1.5
          stitle1 = 'FUV Imagers'+strTitle1
        endif else begin
          ch_size=1.5
          stitle1 = 'FUV Imagers/'+ImageInfo(inst).Inst_id+strTitle1
        endelse
        xpos = gifSizeX / 2
        ypos = gifSizeY - 12 * ch_size
        ypos1 = gifSizeY - 25 * ch_size
        xpos = float(xpos)/float(xwin)
        ypos = float(ypos)/float(ywin)
        ypos1 = float(ypos1)/float(ywin)
        xyouts, xpos, ypos, stitle1, /NORMAL, ALIGNMENT=0.5 $
          ,CHARSIZE=ch_size,COLOR= txt_clr
        xyouts, xpos, ypos1, strTitle2, /NORMAL, ALIGNMENT=0.5 $
          ,CHARSIZE=ch_size,COLOR= txt_clr
       end
     endcase
;
    ; Insert the altitude plot and Housekeeping
;    insertAlt, AltLimits, record
    insertHsk, HskLimits, inst, record
    allflag = 0
    if(cor eq 0 ) then begin
         insertGeoImg, images_limits(0,*), inst,record
         insertMagImg, images_limits(1,*), inst,record,rfresh
         allflag = 1
     endif

    ; Insert the geodetic image representation
      if(cor eq 1) then begin
       k=0
       for i=0, 2 do begin
        if (avail_inst(i) eq 1) then begin
          insertGeoImg, images_limits(k,*), i,record
          k=k+1
        endif
       endfor
      endif
;
 ; Insert the geomagnetic image representation
      if(cor eq 2) then begin
       k=0
       for i=0, 2 do begin
        if (avail_inst(i) eq 1) then begin
          insertMagImg, images_limits(k,*),i,record,rfresh
          k=k+1
        endif
       endfor
      endif

  ; Insert the color bar
    if (baronof) then InsertCbar, CbarLimits,inst, record

 ; Create a filename for Create Gif option

    if (ps_flag eq 0) then tmpfile=get_fname(dstr(record,inst))
; For default (all)
    dummy=-1
    if(cor eq 0 or xdr_flag eq 1)  then begin
        if (ps_flag eq 0 and xdr_flag eq 0) then dummy = tvrd(0,0,640,460)
        return, dummy
    endif
;
; For Geodetic images
    if(cor eq 1 and xdr_flag eq 0)   then begin
          gif_x = 15.5*border+nypix
          if (ps_flag eq 0) then dummy = tvrd(0,0,gifSizeX,gifSizeY)
          return, dummy
    endif

;; For Magnetic
    if(cor eq 2 and xdr_flag eq 0) then begin
          gif_y = 14*border+nypix
          if (ps_flag eq 0) then dummy = tvrd(0,0,gifSizeX,gifSizeY)
          return, dummy
    endif
    stat_txt = 'Done '
     widget_control, status_id, set_value = stat_txt

    catch, error_status
END
