;
function keo_resize,keo_image,n_img_rebin,ncol_rebin
;
  keo_size=size(keo_image)
  n_img=keo_size(1)*n_img_rebin
  ncol=keo_size(2)*ncol_rebin
  resized_img=REPLICATE(0.,n_img,ncol)
  l=0
  for i=0,keo_size(2)-1 do begin
   for j=0,keo_size(1)-1 do $
    for k=0,n_img_rebin-1 do resized_img[(j*n_img_rebin)+k,l]=keo_image[j,i]
   for m=1,ncol_rebin-1 do resized_img[*,l+m]=resized_img[*,l]
   l=l+ncol_rebin
  endfor
  return,resized_img
end
;
pro keowin_event, event
;
@fuv_cmnblk
forward_function keo_filename
;
WIDGET_CONTROL,event.id,GET_UVALUE=type
WIDGET_CONTROL,event.top,GET_UVALUE=info
oldwin=!d.window
wset,info.keo_win

; check which instrument

  case 1 of
  avail_inst[0]: ppp=0
  avail_inst[1]: ppp=1
  avail_inst[2]: ppp=2
  ELSE: ppp=0
  endcase
  
;
case type of
 1: begin
     WIDGET_CONTROL,get_value=keo_index,keoslide
     case keo_mlt_flg of
     1: keo_fval1=(keo_mltmin+(keo_index*keo_mltres)) mod 24.
     0: keo_fval1=(keo_lonmin+(keo_index*keo_lonres)) mod 360.
     2: keo_fval1=(keo_lonmin+(keo_index*keo_lonres)) mod 360.
     endcase
     WIDGET_CONTROL,set_value=keo_fval1,keofield
     display_keo,info.keo_images[*,*,*,keo_index],info.keo_times,info.n_img_rebin,info.ncol_rebin,$
     			 info.n_image,info.max_keo_images,info.keo_xwin,info.keo_ywin,info.disp_txt
    end
;
 2: begin
     result=dialog_message('Use slider to change value')
;     WIDGET_CONTROL,get_value=keo_fval1,keofield
;     case keo_mlt_flg of
;     1: begin
;      if (keo_fval1 ge keo_mltmax) then begin
;       keo_fval1=keo_mltmax-keo_mltres
;       WIDGET_CONTROL,set_value=keo_fval1,keofield
;      endif
;      if (keo_fval1 lt keo_mltmin) then begin
;       keo_fval1=keo_fval1+24.
;       WIDGET_CONTROL,set_value=keo_fval1-24.,keofield
;      endif
;      keo_index=FIX((keo_fval1-keo_mltmin)/keo_mltres)
;     endcase
;     0: begin
;      if (keo_fval1 ge keo_lonmax) then begin
;       keo_fval1=keo_lonmax-keo_lonres
;       WIDGET_CONTROL,set_value=keo_fval1,keofield
;      endif
;      if (keo_fval1 lt keo_lonmin) then begin
;       keo_fval1=keo_fval1+360.
;       WIDGET_CONTROL,set_value=(keo_fval1 mod 360.),keofield
;      endif
;      keo_index=FIX((keo_fval1-keo_lonmin)/keo_lonres)
;     endcase
;     2: begin
;      if (keo_fval1 ge keo_lonmax) then begin
;       keo_fval1=keo_lonmax-keo_lonres
;       WIDGET_CONTROL,set_value=keo_fval1,keofield
;      endif
;      if (keo_fval1 lt keo_lonmin) then begin
;       keo_fval1=keo_fval1+360.
;       WIDGET_CONTROL,set_value=(keo_fval1 mod 360.),keofield
;      endif
;      keo_index=FIX((keo_fval1-keo_lonmin)/keo_lonres)
;     endcase
;     endcase
;     WIDGET_CONTROL,set_value=keo_index,keoslide
;     display_keo,info.keo_images[*,*,*,keo_index],info.keo_times,info.n_img_rebin,info.ncol_rebin,$
;    			 info.n_image,info.max_keo_images,info.keo_xwin,info.keo_ywin,info.disp_txt
    end
;
  3:begin
  		tmp_file=keo_filename(info.keo_times[0,ppp],info.keo_times[info.n_image-1,ppp],keo_index)
  		tmp_file=KEO_GIFPATH+Dir_sep+tmp_file
		WIDGET_CONTROL,keo_status,SET_VALUE='File:'+tmp_file
        ;; plot to Z Buffer
        set_plot, 'Z'
        device, z_Buffering = 1
        device, set_resolution = [info.keo_xwin,info.keo_ywin]
        erase,bkgrnd
        display_keo,info.keo_images[*,*,*,keo_index],info.keo_times,info.n_img_rebin,info.ncol_rebin,$
     			 info.n_image,info.max_keo_images,info.keo_xwin,info.keo_ywin,info.disp_txt
        tmp_img=tvrd(0,0,info.keo_xwin,info.keo_ywin)
        case def_colr of
		       0: WRITE_GIF,tmp_file,tmp_img, r_curr,g_curr,b_curr
		       1: WRITE_GIF,tmp_file,tmp_img, rct,gct,bct
        endcase
        device, z_Buffering = 0
        device, /close
        set_plot,win_dev
  	end
;
  4:begin
  		tmp_file=keo_filename(info.keo_times[0,ppp],info.keo_times[info.n_image-1,ppp],keo_index,/ASCII_DUMP)
  		tmp_file=KEO_ASCIIPATH+Dir_sep+tmp_file
		WIDGET_CONTROL,keo_status,SET_VALUE='File:'+tmp_file
  		keo_ascii,tmp_file,info.keo_images[*,*,*,keo_index],info.keo_times,info.n_image,info.disp_txt
  	end
;
  11:begin
        dummy1 =  dialog_pickfile(/DIR, PATH=KEO_GIFPATH, GET_PATH=KEO_GIFPATHT, $
        	TITLE='Select directory for Keogram Gif images.')
        ; If Cancel not selected
; fix UNIX dialog_pickfile under IDL 6.0
        if (dummy1 ne '') then begin
           numb1=strpos(KEO_GIFPATHT,'/.')
           if (numb1 ne -1) then begin
             numb2=strlen(KEO_GIFPATHT)
             keo_gifpath=strmid(keo_gifpatht,0,numb1)+strmid(keo_gifpatht,numb1+2,numb2-numb1-2)
             endif else KEO_GIFPATH=KEO_GIFPATHT
  	   endif
  	endcase
;
  12:begin
        dummy1 =  dialog_pickfile(/DIR, PATH=KEO_ASCIIPATH, GET_PATH=KEO_ASCIIPATHT, $
        	TITLE='Select directory for Keogram ASCII Dump data.')
; fix UNIX dialog_pickfile under IDL 6.0
        ; If Cancel not selected
        if (dummy1 ne '') then begin
           numb1=strpos(KEO_ASCIIPATHT,'/.')
           if (numb1 ne -1) then begin
             numb2=strlen(KEO_ASCIIPATHT)
             keo_asciipath=strmid(keo_asciipatht,0,numb1)+strmid(keo_asciipatht,numb1+2,numb2-numb1-2)
             endif else KEO_ASCIIPATH=KEO_ASCIIPATHT
  	   endif
  	endcase
;
;
endcase
wset,oldwin
end
;
;
; Create Keogram selected, event procedure
pro create_keo, event
;
@fuv_cmnblk

if (WIDGET_INFO(keodraw_id,/VALID_ID) eq 1) then $
 if (WIDGET_INFO(keodraw_id,/REALIZED)) then begin
  stat_txt= ' Keogram window is already active..'
  WIDGET_CONTROL,status_id, set_value=stat_txt
  return
 endif
;
 stat_txt = 'Processing Keogram Plot...'
 WIDGET_CONTROL,status_id, set_value=stat_txt
 widget_control,/HOURGLASS
 widget_control,event.top,GET_UVALUE=info
 oldinfo=info
 oldwin=!d.window
;
 if (current lt 0) then begin
  stat_txt = 'No Data Available or Selected.....'
  WIDGET_CONTROL,status_id, set_value=stat_txt
  return
 endif
;
;initialization
keo_index=0
keo_fval1=0.0

;Check number of images reuested
  if (num_list le 1) then begin
   n_image=1
   img_index=current
 endif else begin
   n_image=num_list
   img_index=listid
 endelse
 ;
 ;calculate keogram images dimension
 ;

 ncol=abs(FIX((keo_latmax-keo_latmin)/keo_latres))

 case keo_mlt_flg of
 0: begin
  if (keo_lonmax lt keo_lonmin) then $
        nlon=FIX(Round((360.+keo_lonmax-keo_lonmin)/keo_lonres)) else $
        nlon=FIX(Round((keo_lonmax-keo_lonmin)/keo_lonres))
  nmeas=nlon
  disp_txt='Longitude'
  keo_fval1=keo_lonmin
 endcase
 1: begin
  if (keo_mltmax lt keo_mltmin) then $
       	nmlt=FIX(Round((24.+keo_mltmax-keo_mltmin)/keo_mltres)) else $
        nmlt=FIX(Round((keo_mltmax-keo_mltmin)/keo_mltres))
  nmeas=nmlt
  disp_txt='MLT'
  keo_fval1=keo_mltmin
 endcase
 2: begin
  if (keo_lonmax lt keo_lonmin) then $
       	nlon=FIX(Round((360.+keo_lonmax-keo_lonmin)/keo_lonres)) else $
        nlon=FIX(Round((keo_lonmax-keo_lonmin)/keo_lonres))
  nmeas=nlon
  disp_txt='Mag. Lon.'
  keo_fval1=keo_lonmin
 endcase
 3: begin
       nmlt=FIX(abs(keo_latmax-keo_latmin)/keo_latres)
       if (keo_mltmax le keo_mltmin) then $
       	  ncol=FIX(Round((24.+keo_mltmax-keo_mltmin)/keo_mltres)) else $
       	  ncol=FIX(Round((keo_mltmax-keo_mltmin)/keo_mltres))
       nmeas=nmlt
       disp_txt='Mag. Lat.'
       keo_fval1=keo_latmin
 endcase
 endcase
;
 keo_images=REPLICATE(0.,n_image,ncol,3,nmeas)
 keo_times=REPLICATE(0.D,n_image,3)
;
 for j=0,n_image-1 do begin
   for i=0,2 do begin
    if (avail_inst(i) eq 1) then begin
      CASE strlowcase(filetypes) of
      'cdf': getcdf_var,i, img_index[j]
      ELSE: getudf_var,i,img_index[j],ret_err
      ENDCASE
      popkeo_cell,ncol,j,i,nmeas,keo_images,keo_times,nmlt,nlon
    endif
   endfor
 endfor
;
  max_keo_images=240
  keo_xwin=(multi_inst*300)+100
  keo_ywin=240+ 180
  n_img_rebin=ROUND((max_keo_images)/n_image)
  ncol_rebin=ROUND(240./ncol)
;
 keobase=widget_base(/ROW,Title='Keogram Display',GROUP_LEADER=info.base,UVALUE=event.top,MBAR=bar)
 keochi1=widget_base(keobase,/COLUMN)
 keodraw_id=widget_draw(keochi1,XSIZE=keo_xwin,YSIZE=keo_ywin,RETAIN=2)
 keosib1=widget_base(keochi1,/ROW,/ALIGN_CENTER)
; keoslide=widget_slider(keosib1,UVALUE=1,VALUE=0,MAXIMUM=(nmeas-1) > 1,/SUPPRESS_VALUE)
 if (nmeas gt 1) then keoslide=widget_slider(keosib1,UVALUE=1,VALUE=0,MAXIMUM=(nmeas-1),/SUPPRESS_VALUE)
 keofield=CW_FIELD(keosib1,UVALUE=2,TITLE=disp_txt+': ',VALUE=keo_fval1,xsize=8,$
 				   /ROW,/FLOATING,/RETURN_EVENTS)
 keosib2=WIDGET_BASE(keochi1,/ROW,/ALIGN_CENTER)
 keogif=WIDGET_BUTTON(keosib2,VALUE='Create GIF',UVALUE=3)
 keodump=WIDGET_BUTTON(keosib2,VALUE='Create ASCII',UVALUE=4)
 ;
 keo_filepath=WIDGET_BUTTON(bar,VALUE='File',UVALUE=10,/MENU)
 keo_gif_path=WIDGET_BUTTON(keo_filepath,VALUE='GIF File Path',UVALUE=11)
 keo_ASCII_path=WIDGET_BUTTON(keo_filepath,VALUE='ASCII File Path',UVALUE=12)
 keo_status=WIDGET_LABEL(keochi1,VALUE='',/DYNAMIC_RESIZE, /ALIGN_LEFT)

 widget_control,keodraw_id,/REALIZE
 keo_win=!d.window

 keo_info={ keo_images:keo_images,$
 			keo_times:keo_times,$
 			n_img_rebin:n_img_rebin,$
 			ncol_rebin:ncol_rebin,$
 			n_image:n_image,$
 			max_keo_images:max_keo_images,$
 			keo_xwin:keo_xwin,$
 			keo_ywin:keo_ywin,$
 			disp_txt:disp_txt,$
 			keo_win:keo_win $
 		 }
 WIDGET_CONTROL,keobase,SET_UVALUE=keo_info
 xmanager,'keowin',keobase
;
;
;
display_keo,keo_images[*,*,*,keo_index],keo_times,n_img_rebin,ncol_rebin,n_image,max_keo_images,$
            keo_xwin,keo_ywin,disp_txt
;
 info=oldinfo
 widget_control,event.top,SET_UVALUE=info
 wset,oldwin
 stat_txt = 'Process Completed...'
 WIDGET_CONTROL,status_id, set_value=stat_txt
;

end
;
