; %W% %G% 
;
pro apex_to_geo, geoglat, geoglon, apexlat, apexlon, apexfile

; Transform apex coordinates to geographic coordinates.
; This requires a data file (supplied by Art Richmond) which contains
; the apex coordinates for all geographic coordinates on a 1x1 degree
; grid.  The routine works for all latitudes and longitudes, and the
; data file is valid only for the epoch 1997.
;
; hfrey, July 23, 2003

; keep the data in a common block, i.e. read the file only once
common geo_to_apex_data, data

geoglat=apexlat-apexlat
geoglon=apexlon-apexlon
if n_elements(data) le 0 then begin
   alon = fltarr(361,181)
   alat = fltarr(361,181)
   openr, unit, apexfile, /get_lun, /xdr
   readu, unit, alat
   readu, unit, alon
   free_lun, unit
endif
salon = sin(!DTOR*alon)
calon = cos(!DTOR*alon)

glat=(findgen(181)-90.)##(fltarr(361)+1.)
glon=(fltarr(181)+1.)##findgen(361)

for i=0,n_elements(apexlat)-1 do begin
  if (apexlon[i] gt 180.) then apexlon[i]=apexlon[i]-360.
  if (apexlon[i] lt -180.) then apexlon[i]=apexlon[i]+360.
  distance=sqrt((alat-apexlat[i])^2+(alon-apexlon[i])^2)
  ppp=min(distance,index)
  g1glat=glat[index]
  g1glon=glon[index]

  gglat=(findgen(41)/10.-2.+g1glat)##(fltarr(41)+1.)
  gglon=(fltarr(41)+1.)##(findgen(41)/10.-2.+g1glon)

; the interpolation requires longitude 0 to 360
; Map the line segment (-180,180) into a circle in the
; complex plane, perform the interpolation, map back to
; the original line segment
  sapexlon = interpolate(salon, ((gglon+360) mod 360), gglat + 90)
  capexlon = interpolate(calon, ((gglon+360) mod 360), gglat + 90)
  applon = atan(sapexlon,capexlon)/!DTOR
  applat = interpolate(alat, ((gglon+360) mod 360), gglat + 90)

  distance=sqrt((applat-apexlat[i])^2+(applon-apexlon[i])^2)
  ppp=min(distance,index)
  geoglat[i]=gglat[index]
  geoglon[i]=gglon[index]
  endfor

end
