;program add_inst_angles_dbase
;
; program to add data from the ascii database of attitude angles
;
;

kill_sc_loop=0
kill_all_loop=0

print,'****Add_inst_angles****'
print,'-----------------------'

;--- must have access to these files.

;path_2_dbase='$FUV_HOME/attitude/'
dir_sep=path_sep()
path_2_dbase=getenv('FUV_HOME')+dir_sep+'attitude'+dir_sep
dbase_files=['wic_angles.txt','s13_angles.txt','s12_angles.txt']
dbase_files=path_2_dbase + dbase_files


while kill_all_loop eq 0 do begin

  blank=0
  Print,'Enter Spacecraft Number (1:WIC, 2:S13, 3:S12)'
  read,blank


  if blank lt 1 or blank gt 3 then $
	stop,' You must enter a number between 1 and 3'




  blank=blank-1
  get_lun,unit
  openw,unit,dbase_files(blank),/append

  while kill_sc_loop eq 0 do begin

    day=' ' & year=' ' & azi=' ' & coel=' ' & roll=' '

    Print,format='("Enter year (4 digits)",$)'
    read,year
    Print,format='("Enter day of year (up to 3 digits)",$)'
    read,day
    Print,format='("Enter azimuth angle (up to 5 decimal places)",$)'
    read,azi
    Print,format='("Enter co-elevation angle (up to 5 decimal places)",$)'
    read,coel
    Print,format='("Enter roll angle (up to 5 decimal places)",$)'
    read,roll
    printf,unit,format='(2a8,3a10)',year,day,azi,coel,roll


    q_exit=' '  
    print,'Enter Y to do another for this instrument'
    read,q_exit
    q_exit=strcompress(strupcase(q_exit),/rem)
    if q_exit ne 'Y' then begin
	close,unit
	free_lun,unit
	kill_sc_loop=1
    endif
  
  endwhile

  q_exit=' '  
  print,'Enter Y to do another entry'
  read,q_exit
  q_exit=strcompress(strupcase(q_exit),/rem)
  if q_exit ne 'Y' then kill_all_loop=1 else kill_sc_loop=0

endwhile



end
