package provide dBTools 1.0

proc dBcleanDup { UdF iD } {
   global env UDFPaths
           
   upvar $UdF U

# ESTABLISH those directories we will need

   UDFdirPaths $U(P) $U(M) $U(E) $U(I)

# FORM the database file names

   set dbD [file join $UDFPaths(1) $U(I).$iD.DBF]
   set dbN [file join $UDFPaths(1) $U(I).$iD.NDX]

   if { ![file exists $dbD] || ![file exists $dbN] } { return }

   DBdbfOpen $dbD dB 
   DBndxOpen $dbN nX 

   set Len [llength $nX(Key)]
   if { $Len == 0 } { return }

   set dList ""
   set nList ""
   
   for { set J 0 } { $J < $Len } { incr J } {
      set Key1 [lindex $nX(Key) $J]
      set I [expr $J + 1]
      while { $I < $Len } {
         set Key2 [lindex $nX(Key) $I]
         if [string match $Key1 $Key2] {
            set rmDBF [expr [lindex $nX(Pos) $J] - 1]
            set rmNDX [lindex $dB(KeyList) $rmDBF]
            lappend dList $rmDBF
            lappend nList $rmNDX
            set I $Len
            break
         } else { incr I }
      }
   }

   close $dB(fd)
   close $nX(fd)

   if { [llength $dList] > 0 } {
      DBdbfDelete $dbD $dList
      DBndxDelete $dbN $nList
   }
}
