package provide dBTools 1.0

proc dBcleanDir { UdF iD } {
   global env UDFPaths
           
   upvar $UdF U

# ESTABLISH those directories we will need

   UDFdirPaths $U(P) $U(M) $U(E) $U(I)

# FORM the database file names

   set dbD [file join $UDFPaths(1) $U(I).$iD.DBF]
   set dbN [file join $UDFPaths(1) $U(I).$iD.NDX]

   if { ![file exists $dbD] || ![file exists $dbN] } { return }

   DBdbfOpen $dbD dB 

   set Len [llength $dB(KeyList)]
   if { $Len == 0 } { return }

   set dList ""
   set nList ""
   for { set I 0 } { $I < $Len } { incr I } {
      set Entry [lindex $dB(KeyList) $I]
      set Key [lindex $Entry 0]
      binary scan $Key a8a4a3a8a4a3a8 V BYr BDy BMs EYr EDy EMs
      set V [string trim $V] 
      set BDy [string trim $BDy] 
      set BMs [string trim $BMs] 
      set BDy [string trimleft $BDy "0"] 
      set BMs [string trimleft $BMs "0"] 
      if { [string length $BMs] == 0 } { set BMs 0 } 
      set Hr [expr int($BMs / 3600000)]
      set Mn [expr int(($BMs % 3600000) / 60000 )]
      set bName [format %s%d%03d%02d%02d $V $BYr $BDy $Hr $Mn]
      if [string match HD $iD] {
         set hF [file join $UDFPaths(2) ${bName}D]
         set dF [file join $UDFPaths(2) ${bName}D]
         if { ![file exist $hF] || ![file exist $dF] } {
            lappend dList $I     
            lappend nList $Entry     
         }
      } else {
         set vF [file join $UDFPaths(2) ${bName}I]
         if ![file exist $vF] {
         }
      }
   }
   close $dB(fd)

   if { [llength $dList] > 0 } {
      DBdbfDelete $dbD $dList
      DBndxDelete $dbN $nList
   }
}
