# THIS procedure contains the dBAsk GUI front end
                                                                                
package provide dBTools 1.0
                                                                                
proc dBaskGUI { } {
   global env askANS
                                                                                
# READ in the preference file

   GUIprefsRead
   TUreadUDFrc dBAsk askANS
   if ![info exists askANS(TmOut)] { set askANS(TmOut) 15000 }

# LAY out the window names for the GUI frame structure

   set W   .askCntrl

   if { [winfo exists $W] == 0 } {
      wm title . "dBAsk"

      set Wa  .askOPTS
      set Wb  .askUDF
      set WbA .askUDF.lab
      set WbB .askUDF.opts
      set Wc  .askTime
      set Wd  .askList
      set WdA .askList.list
      set WdB .askList.opts

      GUIFrame $W  -1 pack|top||both|true
      GUIFrame $Wa -1 pack|top|w
      GUIFrame $Wb -1 pack|top||both|true
      GUIFrame $WbA -1 pack|left||both|true
      GUIFrame $WbB -1 pack|left||both|true
      GUIFrame $Wc -1 pack|top|w
      GUIFrame $Wd -1 pack|top||both|true
      GUIFrame $WdA -1 pack|left|n
      GUIFrame $WdB -1 pack|right|n
      
      GUILabel $W.lab "DATABASE MANAGEMENT TOOL" c pack|left|center|x|true \
              6 30 "" [list "" 14 bold]

      GUIbuttonPush $W.quit QUIT pack|right "exit"  6
      GUILabel $Wa.lab "ACTIONS" w pack|left 0 9
      GUIbuttonPush $Wa.query QUERY\nDATABASE pack|left \
           "dBaskQuery $WdA.list" 0 11
      $Wa.query configure -font [list fixed]
      GUIbuttonPush $Wa.del DELETE\nENTRY pack|left \
           "dBaskDelete $WdA.list" 0 11
      $Wa.del configure -font [list fixed]
      GUIbuttonPush $Wa.rb REBUILD\nDATABASE pack|left "dBaskReBuild" 0 11
      $Wa.rb configure -font [list fixed]
      GUIbuttonPush $Wa.tb "CREATE\nDIR TREE" pack|left "dBtreeBuild" 0 11
      $Wa.tb configure -font [list fixed]
      GUIbuttonPush $Wa.cl CLEAN\nDATABASE pack|left "dBaskClean" 0 11
      $Wa.cl configure -font [list fixed]
      GUIbuttonPush $Wa.pr PROMOTE\nDATA pack|left "dBaskPromote" 0 11
      $Wa.pr configure -font [list fixed]
      GUIbuttonPush $Wa.in INSTALL\nDATA pack|left "dBaskInstall" 0 11
      $Wa.in configure -font [list fixed]

      GUILabel $WbA.lab "SOURCE" w pack|left 0 9
      set oP(0) N ; set oP(1) H ; set oP(5) NO
      GUudfPMEIV $WbB askANS oP

      GUILabel $Wc.t1 "BEG TIME" w grid|0|0 0 9
      GUILabel $Wc.t2 "END TIME" w grid|1|0 0 9

      set CoL 1
      set tE [list -- yR dY hR mN sC]
      set askANS(yRb) YEAR ; set askANS(dYb) DAY
      set askANS(hRb) HR ; set askANS(mNb) MIN ; set askANS(sCb) SEC
      set askANS(yRe) YEAR ; set askANS(dYe) DAY
      set askANS(hRe) HR ; set askANS(mNe) MIN ; set askANS(sCe) SEC
      for { set CoL 1 } { $CoL < 6 } { incr CoL } {
         set iD [lindex $tE $CoL]  
         set bG ${iD}b ; set eD ${iD}e 
         GUIboxEntry $Wc.$bG grid|0|$CoL 6 askANS($bG)
         GUIboxEntry $Wc.$eD grid|1|$CoL 6 askANS($eD)
         $Wc.$bG configure -fg #0000FF
         $Wc.$eD configure -fg #0000FF

         bind $Wc.$bG <Any-Key> {
            if [string match #0000FF [%W cget -fg]] {
               %W delete 0 end
               %W configure -fg #000000
            }
         }
         bind $Wc.$eD <Any-Key> {
            if [string match #0000FF [%W cget -fg]] {
               %W delete 0 end
               %W configure -fg #000000
            }
         }
      }
      GUIbuttonPush $Wc.reset RESET grid|0|$CoL|news|2 "dBtimeReset $Wc"  6

      set LaB " VIRTUAL  TYPE       BEGINNING TIME           ENDING TIME        UDF KEY"

      GUILabel $WdA.l2 $LaB  w grid|0|0|
      $WdA.l2 configure -font [list fixed]
      GUIboxList $WdA.list  80 20 grid|1|0||5 "" multiple 0 1
      $WdA.list configure -font [list fixed]

      GUIbuttonPush $WdB.clear CLEAR grid|0|0|e "$WdA.list delete 0 end" 0 7
      GUIblankRow $WdB 1 1.0
      GUILabel $WdB.l1 SHOW c grid|2|0|
      $WdB.l1 configure -font [list fixed]
      set askANS(HD) 1
      GUIbuttonCheck $WdB.pidf PIDF grid|3|0 askANS(PIDF) "" 0 8
      GUIbuttonCheck $WdB.vidf VIDF grid|4|0 askANS(VIDF) "" 0 8
      GUIbuttonCheck $WdB.hd DATA grid|5|0 askANS(HD) "" 0 8
      GUIblankRow $WdB 5 1.0
      GUILabel $WdB.l2 "GROUPING" c grid|7|0
      $WdB.l2 configure -font [list fixed]
      set askANS(VSORT) 0
      GUIbuttonRadio $WdB.ns NONE grid|8|0 askANS(VSORT) 0 "" 0 8
      GUIbuttonRadio $WdB.vs VIRTUAL grid|9|0 askANS(VSORT) 1 "" 0 8
   }
}
