# THIS procedure rebuilds the database(s) for the selected PMEIV
                                                                                
package provide dBTools 1.0
                                                                                
proc dBRebuild { UdF iD } {
   global env askANS UDFPaths SySCmDs

   upvar $UdF U

# ESTABLISH the file terminator

  if [string match HD $iD] { set fT D } else { set fT I }

# ESTABLISH those directories we will need

   UDFdirPaths $U(P) $U(M) $U(E) $U(I)

# FORM the database entry file

   set dbE [file join $UDFPaths(1) dB.asc]

# NUKE the database we are going to rebuild

   set dbD [file join $UDFPaths(1) $U(I).$iD.DBF]
   set dbN [file join $UDFPaths(1) $U(I).$iD.NDX]
   if [file exists $dbD] { file delete -force $dbD }
   if [file exists $dbN] { file delete -force $dbN }

# GET a listing of all the files in the data directory

   set aNames [exec $SySCmDs(ls) $UDFPaths(2)] 
   set fNames ""

# GET a list of the needed files  

   set fLen [llength $aNames]
   for { set I 0 } { $I < $fLen } { incr I } {
      if {[string index [lindex $aNames $I] end] == $fT} {
         lappend fNames [lindex $aNames $I]
      }
   }

# GENERATE the database entries and put them into the database
   
   DBgenEntries $fT $UDFPaths(2) $UDFPaths(2) $dbE $fNames 
   set ePos [DBdbfAppend $dbD $dbE]
   DBndxAppend $dbN $dbE $ePos
   file delete -force $dbE
}
