package provide GMenu 1.0

proc GM_TkPloT { } {
   global MeNuTemplates MeNuPages MeNuSave MeNuTkPlot GoOn env sP ExT SySCmDs

   if { [string length $ExT] > 0 } {
      set mF $MeNuSave.$ExT
   } else { set mF $MeNuSave }

   set OpenMenu [file join $sP $mF]

   set Len [llength [split $MeNuTkPlot :]]
   if { $Len > 1 } {
      for {set j 0} {$j < $Len} {incr j} {
         set Fld [lindex [split $MeNuTkPlot :] $j]
         set Fc [string index $Fld 0]
         if { [string match "$" $Fc ] == 1 } {
              set Ev [string trimleft $Fld "$"]
              set Fld $env($Ev)
         }
         if { $j == 0 } {
            set RunPrgm $Fld
         } else {
            set RunPrgm [file join $RunPrgm $Fld]
         }
      }
   } else { set RunPrgm $MeNuTkPlot }
   if { [string length $SySCmDs(ext)] > 0 } { append RunPrgm $SySCmDs(ext) }

   set input [open "|$RunPrgm $OpenMenu" r ]
   while { [gets $input line] >= 0 } {
      regexp "(\[^ \]*) *(.*)" $line M CmD Rest
      switch -exact -- $CmD {
         START    {  toplevel .pLoT 
                     eval   {canvas .pLoT.drw} $Rest
                     pack   .pLoT.drw -side bottom -fill both -expand true
                     frame .pLoT.top -relief ridge 
                     pack  .pLoT.top -side top -fill both
                     button .pLoT.top.status -text ACTIVE -fg red
                     pack   .pLoT.top.status -side right -fill x 
                  }

         END      {  catch { close $input } result
                     destroy .pLoT 
                     break;
                  } 

         INOUT    {  .pLoT.top.status config -text CONTINUE 
                     .pLoT.top.status config -fg blue 
                     .pLoT.top.status config -command { set GoOn 1}
                     tkwait variable GoOn
                     .pLoT.top.status config -text ACTIVE 
                     .pLoT.top.status config -fg red 
                  }

         ERROR    {  GM_DecodeErr $line 
                     return
                  }

         FLUSH    {  update idletasks }

         default  {  eval {.pLoT.drw create} $line }
      }
   }
}
