package provide GMenu 1.0

proc GM_QState {Pn Qn Pos Act} {
   global  QuEsCReply QuEsState QuEsActInfo \
           PaGeBase PaGeNQues QuEsOpReply QuEsSact

   set Qp [expr $PaGeBase($Pn) + $Qn]
   set Ap [expr $QuEsSact($Qp) + $Pos]

   set P1 {([^ ]*) *}
   set P2 "(.*)"
   regexp "$P1$P1$P2" $QuEsActInfo($Ap) M TPn TQs Cond

   set TSeg [split $TQs :]
   set Len [llength $TSeg]
   for {set J 0} { $J < $Len } { incr J } {
      set TQn [lindex $TSeg $J] 
      set TQ [split $TQn -]
      if { [llength $TQ] == 1 } { 
         set End [lindex $TQ 0] 
      } else { set End [lindex $TQ 1] } 

      for {set i [lindex $TQ 0]} { $i <= $End } { incr i } {
         set Qt [expr $PaGeBase($TPn) + $i]
         if {[GM_ChkCond $Pn $Qn $Cond] == 1} {
            if { $QuEsState($Qt) != $Act } {
                set QuEsState($Qt) $Act
                GM_ChgState $TPn $i
            } 
         }
      }
   }
}

proc GM_ChgState { Pn Qn } {
   global PaGeNQues PaGeBase QuEsOpts\
          QuEsLabel QuEsGuide QuEsHelp QuEsRets QuEsFmt QuEsCReply \
          QuEsNopts QuEsSopt QuEsNacts QuEsSact QuEsState QuEsCol \
          QuEsAct QuEsActInfo QuEsFrame QuEsQPos QuEsNoHelp Prefs

   set Qp [expr $PaGeBase($Pn) + $Qn]
   set Bw $QuEsFrame($Qp)
   set W .pg$Pn.$Bw.qs$Qn
   set BBCol [list BDisCol BBgCol BBgCol]
   set BLCol [list LDisCol BFgCol BMutCol]
   set ELCol [list LDisCol EFgCol EMutCol]
   set EBCol [list EDisCol EBgCol EBgCol]
   set StatE [list disabled normal disabled]

   if {[string match opt* $Bw] == 0 } {
       set W .pg$Pn.$Bw.qs$Qn
       set Wl .pg$Pn.$Bw.qlab$Qn
   } else { 
       set W ".pg$Pn.$Bw.$QuEsCol($Qp).qs$Qn"
       set Wl ".pg$Pn.$Bw.$QuEsCol($Qp).qlab$Qn" 
   }

   set St [lindex $StatE $QuEsState($Qp)]
   set El $Prefs([lindex $ELCol $QuEsState($Qp)])
   set Eb $Prefs([lindex $EBCol $QuEsState($Qp)])
   set Bl $Prefs([lindex $BLCol $QuEsState($Qp)])
   set Bb $Prefs([lindex $BBCol $QuEsState($Qp)])

   switch -glob -- $QuEsAct($QuEsSact($Qp)) {
      REPLY*    {  for {set j  0} {$j < $QuEsRets($Qp)} {incr j} {
                       $W{$j} configure -state $St -bg $Eb -fg $El
                   }
                }
      OPTIONS*  { $W configure -state $St -disabledforeground $Bl -bg $Bb}
      UDF*      { $W configure -state $St -disabledforeground $Bl -bg $Bb}
      PIDF*     { $W configure -state $St -disabledforeground $Bl -bg $Bb}
      ADDPAGE*  { .pg$Pn.$Bw.left$Qn configure -state $St -bg $Bb \
                                               -disabledforeground $Bc
                  .pg$Pn.$Bw.right$Qn configure -state $St -bg $Bb \
                                               -disabledforeground $Bc
                }
      SADDPAGE* { .pg$Pn.$Bw.left$Qn configure -state $St -bg $Bb \
                                               -disabledforeground $Bc
                  .pg$Pn.$Bw.right$Qn configure -state $St -bg $Bb \
                                               -disabledforeground $Bc
                }
   }
}
