package provide GMenu 1.0

proc GM_SaveMenuPreface { FD TER } {
   global MeNuTemplates MeNuPages MeNuSave MeNuExec MeNuTkPlot \
          MeNuCom1 MeNuCom2 

   puts $FD "TEMPLATES\t$MeNuTemplates"
   puts $FD "PAGES\t\t$MeNuPages"
   if {[string length $MeNuExec] > 0} { puts $FD "RUN\t\t$MeNuExec" }
   if {[string length $MeNuTkPlot] > 0} { puts $FD "TKPLOT\t\t$MeNuTkPlot" }
   if {[string length $MeNuCom1] > 0} { puts $FD "COM1\t\t$MeNuCom1" }
   if {[string length $MeNuCom2] > 0} { puts $FD "COM2\t\t$MeNuCom2" }
   puts $FD $TER
}

# SAVE THE DEFINED TEMPLATE INFORMATION

proc GM_SaveTemplateInfo { FD TER } {
   global MeNuTemplates MeNuPages MeNuSave MeNuLoad MeNuTFile MeNuTNums

   for {set i 0} {$i < $MeNuTemplates } {incr i} {
       puts $FD "TEMPLATE\t$MeNuTFile($i)\t$MeNuTNums($i)"
   }
   puts $FD $TER
}

proc GM_SavePagePreface { FD N } {
   global PaGeTitle PaGeNQues PaGeBase MeNuPgOffs PaGeParPg PaGeParQs \
          PaGeCWidth

   set Pn [expr $N - $MeNuPgOffs($N)]
   puts $FD "PAGE\t\t$Pn"
   puts $FD "QUESTIONS\t$PaGeNQues($N)"
   puts $FD "TITLE\t\t$PaGeTitle($N)"
   if {$PaGeCWidth($N) != 10 } {puts $FD "CWIDTH\t\t$PaGeCWidth($N)"}
   if {$PaGeParPg($N) >= 0} { 
      puts $FD "PARPG\t\t[GM_CorWns $N $N 4]"
      puts $FD "PARQS\t\t$PaGeParQs($N)"
   }
}

# SAVE QUESTION INFORMATION ASSOCIATED WITH MENU PAGE Pn
# SAVE ONLY THOSE FIELDS WHICH ARE DIFFERENT FROM THE 
# DEFAULT VALUES

proc GM_SaveQuesInfo { FD Pn } {
   global QuEsLabel QuEsGuide QuEsHelp QuEsRets QuEsFmt QuEsCReply \
          QuEsNopts QuEsSopt QuEsNacts QuEsSact QuEsState QuEsOpReply \
          PaGeBase PaGeNQues QuEsNWins QuEsWns QuEsAltVal QuEsRBox \
          QuEsQLoc QuEsQPos QuEsID QuEsLPos QuEsCol QuEsColSpan \
          QuEsNoHelp PaGeCWidth
 
   set N $PaGeBase($Pn)
   for {set i 0} {$i < $PaGeNQues($Pn) } {incr i} {
       puts $FD "|********** BEGIN QUESTION $i **********|"
       if { [string length $QuEsLabel($N)] > 0 } {
          puts $FD "LABEL\t\t$QuEsLabel($N)" }
       if { $QuEsID($N) >= 0 } {
          puts $FD "ID\t\t$QuEsID($N)" }
       if { [string length $QuEsGuide($N)] > 0 } {
          puts $FD "GUIDE\t\t$QuEsGuide($N)" }
       if { [string length $QuEsHelp($N)] > 0 } { 
          puts $FD "HELP\t\t$QuEsHelp($N)" }
       if { $QuEsRBox($N) != $PaGeCWidth($Pn) } { 
          puts $FD "RBOX\t\t$QuEsRBox($N)" }
       if { $QuEsColSpan($N) != 1 } { 
          puts $FD "CSPAN\t\t$QuEsColSpan($N)" }
       if { $QuEsNoHelp($N) == 1 } { 
          puts $FD "NOHELP\t\t$QuEsNoHelp($N)" }

       if { $QuEsCol($N) == 2} { 
          if { [string compare $QuEsLPos($N) "w"] != 0 } {
             puts $FD "LPOS\t\t$QuEsLPos($N)" }
       } else {
          if { [string compare $QuEsLPos($N) "e"] != 0 } {
             puts $FD "LPOS\t\t$QuEsLPos($N)" }
       }

       if { $QuEsRets($N) > 0 } { 
          puts $FD "RNUM\t\t$QuEsRets($N)" }
       if { $QuEsState($N) != 1 } { 
          puts $FD "STATE\t\t$QuEsState($N)" }
       if { [string length $QuEsFmt($N)] > 0 } { 
          puts $FD "FMT\t\t$QuEsFmt($N)" }
       if { [string length $QuEsQPos($N)] > 0 } { 
          puts $FD "QPOS\t\t$QuEsQPos($N)" }
       if { [string length $QuEsQLoc($N)] > 0 } { 
          puts $FD "QLOC\t\t$QuEsQLoc($N)" }
       if { [string length $QuEsOpReply($N)] > 0 } { 
          puts $FD "OPREPLY\t\t$QuEsOpReply($N)" }
       if {[string length $QuEsAltVal($N)] > 0 } { 
          puts $FD "ALTVAL\t\t$QuEsAltVal($N)" }
       if { $QuEsNWins($N) > 0 } { 
          puts $FD "NWINS\t\t$QuEsNWins($N)" 
          puts $FD "WINS\t\t[GM_CorWns $Pn $N 3]"        
       } 

       set Reply ""
       if { $QuEsRets($N) < 2 } { 
          if { [string length $QuEsCReply($N,0)] > 0 } { 
              set Reply "$QuEsCReply($N,0)" }
       } else {
          set Reply "$QuEsCReply($N,0)"
          for {set j 1} {$j < $QuEsRets($N) } {incr j} {
              append Reply "|$QuEsCReply($N,$j)"
          }
       }
       if { [string length $Reply] > 0 } { 
          puts $FD "CREPLY\t\t$Reply" } 

       GM_SaveActInfo $FD $Pn $N
       if { $QuEsNopts($N) > 0 } { GM_SaveOptInfo $FD $N }
       incr N
   }
   puts $FD "|**************************************|"
}

# SAVE ALL OPTION INFORMATION ASSOCIATED WITH THE QUESTION HELD
# AT POSTION Qp IN THE QUESTION ARRAY

proc GM_SaveOptInfo { FD Qp} {
   global QuEsNopts QuEsSopt QuEsOpts QuEsOval
 
   set N $QuEsSopt($Qp)
   set Ops ""
   append Ops "$QuEsOpts($N)|$QuEsOval($N)"
   incr N
   for {set i 1} {$i < $QuEsNopts($Qp) } {incr i} {
       append Ops ":$QuEsOpts($N)|$QuEsOval($N)"
       incr N
   }
#  puts $FD "OPTION\t\t$QuEsOpts($N)\t$QuEsOval($N)"
   puts $FD "OPTION\t\t$Ops"
}

# CORRECT WINDOW NUMBERS FOR WRITE DOWN

proc GM_CorWns { Pn N Type } {
   global QuEsNacts QuEsSact QuEsAct QuEsActInfo MeNuPgOffs \
          QuEsNWins QuEsWns PaGeParPg 

   set P1 {([^ ]*) *}
   switch -exact -- $Type {
      -1 {  set TmP $QuEsActInfo($N)
         }

      0  {  set TmP $QuEsActInfo($N)
            regexp "$P1" $TmP M Pg 
            set Npg [expr $Pg - $MeNuPgOffs($Pg)]
            regsub $Pg $TmP $Npg TmP 
         }
      1  {  set TmP $QuEsActInfo($N)
            regexp "$P1$P1" $TmP M ID Pg
            switch -glob -- $ID {
                PROJECT*  { }
                default   { set Npg [expr $Pg - $MeNuPgOffs($Pg)]
                             regsub $Pg $TmP $Npg TmP 
                           }
            }
         }
      2  {  set TmP $QuEsActInfo($N)
            set PG ""  
            regexp "$P1$P1$P1$P1$P1$P1$P1$P1$P1" $TmP \
                                     M ID Pg V1 V2 V3 V4 V5 PG V6
            set Npg [expr $Pg - $MeNuPgOffs($Pg)]
            if { [string length $PG] > 0 } {
               set NPG [expr $PG - $MeNuPgOffs($PG)]
               set TmP "$ID $Npg $V1 $V2 $V3 $V4 $V5 $NPG $V6" 
            } else { regsub $Pg $TmP $Npg TmP } 
         }
      3  {  set TmP $QuEsWns($N)
            for {set i 0} {$i < $QuEsNWins($N) } {incr i} {
               set Pg [lindex $TmP $i]
               set Npg [expr $Pg - $MeNuPgOffs($Pg)]
               set TmP [lreplace $TmP $i $i $Npg]
            }
         }

      4  { set Npg [expr $PaGeParPg($N) - $MeNuPgOffs($PaGeParPg($N))]
           set TmP $Npg
         }
   }

   return $TmP
}

# SAVE ALL ACTION INFORMATION ASSOCIATED WITH THE QUESTION HELD
# AT POSTION Qp IN THE QUESTION ARRAY

proc GM_SaveActInfo { FD Pn Qp} {
   global QuEsNacts QuEsSact QuEsAct QuEsActInfo MeNuPgOffs
 
   set N $QuEsSact($Qp)
   set P1 {([^ ]*) *}
   for {set i 0} {$i < $QuEsNacts($Qp) } {incr i} {
     set PassIn -1
     if {[string length QuEsActInfo($N)] > 0} {
        switch -glob -- $QuEsAct($N) {
             INVISIBLE* { set PassIn 0 }
             VISIBLE*   { set PassIn 0 }
             MUTE*      { set PassIn 0 }
             ZERO*      { set PassIn 0 }
             UDF*       { set PassIn 1 }
             PIDF*      { set PassIn 2 }
             EPUT*      { set PassIn 0 }
             EMPUT*     { set PassIn 0 }
             PUT*       { set PassIn 0 }
             GET*       { set PassIn 0 }
             SET*       { set PassIn 0 }
             DOACTIVES* { set PassIn 0 }
         }
      } 
      puts $FD "ACTINFO\t\t$QuEsAct($N)\t[GM_CorWns $Pn $N $PassIn]"
      incr N
   }
}

# THE MENU WRITE DOWN PROCEDURE (THE SAVE MENU)  THIS WRITES DOWN ALL
# THE CURRENT MENU OPTIONS TO THE FILE DESIGNATED IN THE SAVE DIALOG
# BOX THEN COPIES THAT NAME TO THE LOAD FILE DIALOG BOX

proc GM_SaveMenu { } {
   global MeNuSave MeNuPages MeNuTemplates MeNuMaxPg MeNuPgNums\
          PaGeBase QuEsLabel MenuLoaded MeNuPgOffs sP ExT

   if { $MenuLoaded == 0 } { return } 

   GM_PgOffsets

   set TER |**************************************|
   set MeNuSave [.gmMAIN.sent get]

   if { [string length $ExT] > 0 } {
      set mF $MeNuSave.$ExT
   } else { set mF $MeNuSave }

   set Fn [file join $sP $mF ]
   set FS [open $Fn w]
   GM_SaveMenuPreface $FS $TER
   if {$MeNuTemplates > 0} { GM_SaveTemplateInfo $FS $TER }
   for {set Pn 0} {$Pn < $MeNuMaxPg} {incr Pn} {
      if {$MeNuPgNums($Pn) >= 0} {
         GM_SavePagePreface $FS $MeNuPgNums($Pn)
         GM_SaveQuesInfo $FS $MeNuPgNums($Pn)
      }
   }
   close $FS
}
