#THIS PROCEDURE DETERMINES THE FULL PIDF PATH NAME

package provide GMenu 1.0

proc GM_PidfPath { P M E I V } {
   global env BasePidfPath DbPaths NPidfSpec PidfSpecID PidfSpecPath 

   if { $DbPaths == 0 } { GM_GetDbPaths }

   set pmeiv "$P:$M:$E:$I:$V" 
   set Comps [split $pmeiv :]]

   for {set j 0} {$j < $NPidfSpec } {incr j} {
      set ToMatch $P
      set Len [llength [split $PidfSpecID($j) :]]
      set J 1
      while { $J < $Len } {
         append ToMatch ":[lindex $Comps $J]"
         incr J
      }
      if {[string match $ToMatch $PidfSpecID($j)] == 1 } { break }
   }

   if {$j < $NPidfSpec} {
      if {[string match "$*" $PidfSpecPath($j)] == 1} {  
         regexp {\$([^/]*).(.*)} $PidfSpecPath($j) Ma En rest
         set path $env($En)
         regexp {([^%]*)} $rest Ma rest 
         set Paths [file split $rest]
         set Dirs [llength $Paths]
         for {set i 0} { $i < $Dirs } { incr i } {
             set path [file join $path [lindex $Paths $i]]
         }
      } else { 
          regexp {([^%]*)} $PidfSpecPath($j) Ma rest 
          set Paths [file split $rest]
          set Dirs [llength $Paths]
          set path ""
          for {set i 0} { $i < $Dirs } { incr i } {
             set path [file join $path [lindex $Paths $i]]
          }
      }
      set path [file join $path  $V.pidf.v2 ]
   } else {
      if {[string match "\$*" $BasePidfPath] == 1} {  
         regexp {\$(.*)} $BasePidfPath Ma En
         set path [file join $env($En) $P $M $E $I $V.pidf.v2]
      }
   }
   return $path
}

# THIS PROCEDURE HANDLES ALL OF THE PIDF OPTIONS.  IF THE CURRENT PIDF IN
# MEMORY IS NOT THAT NEEDED THEN A NEW PIDF IS LOADED.  A PIDF IS CONSIDERED
# UNIQUE ACCORDING TO ITS PATH NAME.  THE PATH NAME OF THE CURRENTLY LOADED
# PIDF IS KEPT IN PIDFRead.

proc GM_PIDFRipple { Pn Qn } { 
   global PaGeBase QuEsSopt QuEsCReply QuEsNopts QuEsOpts QuEsOval \
          QuEsOpReply QuEsAct QuEsSact QuEsActInfo PIDFRead \
          PIDFnumgrps PIDFgrpnms QuEsFrame PIDFmodename \
          PIDFnummodes

   set Qp [expr $PaGeBase($Pn) + $Qn]
   set Ap $QuEsSact($Qp)
   set QuEsOpReply($Qp) -1
   set PG -1
   set V1 -1
   set V2 -1

   set P1 {([^ ]*) *}
   regexp "$P1$P1$P1$P1$P1$P1$P1$P1$P1$P1" $QuEsActInfo($Ap) \
                             M Type Pg VP VM VE VI VV PG V1 V2

   set QP [expr $PaGeBase($Pg) + $VP]
   set QM [expr $PaGeBase($Pg) + $VM]
   set QE [expr $PaGeBase($Pg) + $VE]
   set QI [expr $PaGeBase($Pg) + $VI]
   set QV [expr $PaGeBase($Pg) + $VV]
   set Fn [GM_PidfPath $QuEsCReply($QP,0) $QuEsCReply($QM,0) \
                   $QuEsCReply($QI,0) $QuEsCReply($QE,0) $QuEsCReply($QV,0) ]

   set PmEiV [list $QuEsCReply($QP,0) $QuEsCReply($QM,0) \
             $QuEsCReply($QE,0) $QuEsCReply($QI,0) $QuEsCReply($QV,0) ]
   if {[string compare $PIDFRead $Fn] != 0} {GM_ReadPIDF $Fn $PmEiV }

   switch -glob -- $Type {
      DATATYPES*     {  GM_PIDFData   $Pn $Qn }
      GROUPS*        {  GM_PIDFGroups $Pn $Qn $PG $V1}
      MODES*         {  GM_PIDFModes  $Pn $Qn   }
      COMPONENT*     {  GM_PIDFComponents $Pn $Qn $PG $V1 $V2         }
      ANCILLARY*     {  GM_PIDFAncillary $Pn $Qn $PG $V1              }
      SENUNITS*      {  GM_PIDFUnits $Pn $Qn $PG $V1 SEN              }
      SCANUNITS*     {  GM_PIDFUnits $Pn $Qn $PG $V1 SCAN             }
      MODEUNITS*     {  GM_PIDFUnits $Pn $Qn $PG $V1 MODE             }
      ANCUNITS*      {  GM_PIDFUnits $Pn $Qn $PG $V1 ANC              }
      DQUNITS*       {  GM_PIDFUnits $Pn $Qn $PG $V1 DQ               }
   }
}

proc GM_PIDFModes { Pn Qn } {
   global PIDFnummodes QuEsFrame PaGeBase PIDFmodename QuEsRBox \
          PIDFmodepidfN CurOpVal QuEsCol
 
   set Qp [expr $PaGeBase($Pn) + $Qn]

   if { [string match opt* $QuEsFrame($Qp)] == 0 } {
      set W ".pg$Pn.$QuEsFrame($Qp).qs$Qn"
   } else {
      set W ".pg$Pn.$QuEsFrame($Qp).$QuEsCol($Qp).qs$Qn"
   } 

   set MaxL 1
   set Ops ""
   for {set j 0} {$j < $PIDFnummodes} {incr j} {
      set SLen [string length $PIDFmodename($j)]
      if {$SLen > $MaxL} {set MaxL $SLen }
      set CurOpVal($j) "$PIDFmodepidfN($j)"
      lappend Ops $PIDFmodename($j)
   }
   set MaxL [expr $MaxL + 2]
   if {$QuEsRBox($Qp) > $MaxL} {set MaxL $QuEsRBox($Qp) }
   GUIbuttonMenu $W "" grid|0|0 $Ops "GM_ProcessOpt $Pn $Qn 0" 0 $MaxL
}

proc GM_PIDFGroups { Pn Qn Pg V1} {
   global PIDFnumgrps QuEsFrame PaGeBase PIDFgrpnms QuEsRBox CurOpVal \
          QuEsCol PIDFsengrpN PIDFnumsens PIDFsensource QuEsAltVal
 
   set Qp [expr $PaGeBase($Pn) + $Qn]
   if {$Pg >= 0 } {
      set QP [expr $PaGeBase($Pg) + $V1]
      set Dt $QuEsAltVal($QP)
   } else { set Dt 0 }

   if { [string match opt* $QuEsFrame($Qp)] == 0 } {
      set W ".pg$Pn.$QuEsFrame($Qp).qs$Qn"
   } else {
      set W ".pg$Pn.$QuEsFrame($Qp).$QuEsCol($Qp).qs$Qn"
   } 


# IF NOT ASKING FOR ANCILLARY DATA THEN SHOW ALL GROUPS OTHERWISE SHOW JUST
# GROUPTS WHICH HAVE SENSORS WHICH HAVE A VIDF SOURCE   

   set Ops ""
   set MaxL 1
   if {$Dt != 2} {
      for {set j 0} {$j < $PIDFnumgrps} {incr j} {
         set SLen [string length $PIDFgrpnms($j)]
         if {$SLen > $MaxL} {set MaxL $SLen }
         set CurOpVal($j) $j
         lappend Ops $PIDFgrpnms($j)
      }
   } else {
      for {set j 0} {$j < $PIDFnumgrps } {incr j} {
          for {set i 0} {$i < $PIDFnumsens } {incr i} {
             if {$PIDFsengrpN($i) == $j && \
                    [string match $PIDFsensource($i) "V"] == 1} {
                set SLen [string length $PIDFgrpnms($j)]
                if {$SLen > $MaxL} {set MaxL $SLen }
                set CurOpVal($j) $j
                lappend Ops $PIDFgrpnms($j)
                break;
             }
          }
      }
   }

   set MaxL [expr $MaxL + 2]
   if {$QuEsRBox($Qp) > $MaxL} {set MaxL $QuEsRBox($Qp) }
   GUIbuttonMenu $W "" grid|0|0 $Ops "GM_ProcessOpt $Pn $Qn 0" 0 $MaxL
}

proc GM_PIDFUnits { Pn Qn Pg V1 Type} {
   global PIDFunitmin  PIDFunitmax  PIDFunitsca  PIDFunitlab QuEsRBox \
          PIDFunitLdes  PIDFunitSdes  PIDFunitNtab PIDFsenscanblk \
          PIDFsenunits PaGeBase QuEsState QuEsOpReply CurOpVal QuEsAltVal \
          PIDFscanblkN  PIDFscanNunits  PIDFscanspace PIDFscanunits \
          PIDFmodeunits  PIDFancunits QuEsFrame QuEsLabel PIDFdqunits QuEsCol
 
   set Qp [expr $PaGeBase($Pn) + $Qn]
   if { [string match DQ $Type] == 0 } { 
      set QP [expr $PaGeBase($Pg) + $V1]
      regexp {([0-9]*).*} $QuEsAltVal($QP) M Sn
   }
   set MaxL 1
   set i  0

   if { [string match opt* $QuEsFrame($Qp)] == 0 } {
      set W ".pg$Pn.$QuEsFrame($Qp).qs$Qn"
   } else {
      set W ".pg$Pn.$QuEsFrame($Qp).$QuEsCol($Qp).qs$Qn"
   } 

   set OK 1
   switch -exact -- $Type {
      SEN    {  set SrC $PIDFsenunits($Sn) }
      SCAN   {  if {$PIDFsenscanblk($Sn) >= 0 } {
                  set SrC $PIDFscanunits($PIDFsenscanblk($Sn)) 
                } else { set OK 0 }
             }
      MODE   {  set SrC $PIDFmodeunits($Sn) }
      ANC    {  set SrC $PIDFancunits($Sn)  }
      DQ     {  set SrC $PIDFdqunits        }
   }

   set Ops ""
   if {$OK == 1 } {
      while {[string length $SrC] > 0 } {
         regexp {([0-9]*) (.*)} $SrC M U SrC
         lappend Ops "$PIDFunitLdes($U) ($PIDFunitlab($U))"
         set SLen [string length "$PIDFunitLdes($U) ($PIDFunitlab($U))"]
         if {$SLen > $MaxL} {set MaxL $SLen }
         set CurOpVal($i) "$U"
         incr i
      }
      set MaxL [expr $MaxL + 2]
      if {$QuEsRBox($Qp) > $MaxL} {set MaxL $QuEsRBox($Qp) }
      GUIbuttonMenu $W "" grid|0|0 $Ops "GM_ProcessOpt $Pn $Qn 0" 0 $MaxL
   } else {
      if { $QuEsState($Qp) == 1 } {
         GM_HelpMesg $Pn $Qn 2 "SCALAR VIRTUAL - NO SCAN UNITS"
         $W configure -text "UnDefined" -font default
         set QuEsState($Qp) 0
         GM_ChgState  $Pn $Qn 
      } 
   }
}

proc GM_PIDFAncillary { Pn Qn Pg V1} {
   global  PaGeBase QuEsOpReply CurOpVal PIDFsenvidfN QuEsFrame QuEsRBox \
           PIDFancmodflag PIDFancsenN PIDFNancsen PIDFancname \
           PIDFancpidfN PIDFnumancs QuEsCol 

 
   set Qp [expr $PaGeBase($Pn) + $Qn]
   set QP [expr $PaGeBase($Pg) + $V1]
   set Vn $PIDFsenvidfN($QuEsOpReply($QP))
   set MaxL 1
   set Yes Y

   if { [string match opt* $QuEsFrame($Qp)] == 0 } {
      set W ".pg$Pn.$QuEsFrame($Qp).qs$Qn"
   } else {
      set W ".pg$Pn.$QuEsFrame($Qp).$QuEsCol($Qp).qs$Qn"
   } 

#  GET THE NUMBER OF COMPONENTS TO DISPLAY

   set i 0
   for {set j 0} {$j < $PIDFnumancs } {incr j} {
      if {$PIDFNancsen($j) < 0} {
         incr i
      } elseif {[string match $PIDFancmodflag($j) $Yes] == 1 } {
         incr i 
      } else {
         for {set k 0} {$k < $PIDFNancsen($j) } {incr k} {
             if {$PIDFancsenN($k) == $Vn} { incr i }
         }
      }
   }           

   set i 0
   set Ops ""
   for {set j 0} {$j < $PIDFnumancs } {incr j} {
      set Add 0;
      if {$PIDFNancsen($j) < 0} {
         set Add 1;
      } elseif {[string match $PIDFancmodflag($j) $Yes] == 1 } { 
         set Add 1
      } else {
         for {set k 0} {$k < $PIDFNancsen($j) } {incr k} {
            if {$PIDFancsenN($k) == $Vn} { 
               set Add 1
               break
            }
         }
      }
      if { $Add == 1 } {
         lappend Ops $PIDFancname($j)
         set SLen [string length $PIDFancname($j)]
         if {$SLen > $MaxL} {set MaxL $SLen }
         set CurOpVal($i) "$PIDFancpidfN($j)"
         incr i
      }
   }           
   set MaxL [expr $MaxL + 2]
   if {$QuEsRBox($Qp) > $MaxL} {set MaxL $QuEsRBox($Qp) }
   GUIbuttonMenu $W "" grid|0|0 $Ops "GM_ProcessOpt $Pn $Qn 0" 0 $MaxL
}

proc GM_PIDFComponents { Pn Qn Pg V1 V2} {
   global PIDFsengrpN PIDFsencomp PIDFnumsens PaGeBase QuEsOpReply \
          CurOpVal PIDFsenpidfN PIDFsenvidfN QuEsFrame QuEsRBox QuEsCol \
          QuEsAltVal PIDFsensource
 
   set Qp [expr $PaGeBase($Pn) + $Qn]
   set QP [expr $PaGeBase($Pg) + $V1]
   set Gn $QuEsOpReply($QP)
   if {$V2 >= 0 } {
      set QP [expr $PaGeBase($Pg) + $V2]
      set Dt $QuEsAltVal($QP)
   } else { set Dt 0 }
   set MaxL 1


   if { [string match opt* $QuEsFrame($Qp)] == 0 } {
      set W ".pg$Pn.$QuEsFrame($Qp).qs$Qn"
   } else {
      set W ".pg$Pn.$QuEsFrame($Qp).$QuEsCol($Qp).qs$Qn"
   } 

#  GET THE NUMBER OF COMPONENTS TO DISPLAY

   set i 0
   for {set j 0} {$j < $PIDFnumsens } {incr j} {
      if {$PIDFsengrpN($j) == $Gn} {
         incr i
      }
   }

   set i 0
   set Ops ""
   for {set j 0} {$j < $PIDFnumsens } {incr j} {
      if {$PIDFsengrpN($j) == $Gn} {
         if {$Dt == 2  && [string match $PIDFsensource($i) "V"] == 1} {
             lappend Ops $PIDFsencomp($j) 
         } else {
             lappend Ops $PIDFsencomp($j) 
         }
         set SLen [string length $PIDFsencomp($j)]
         if {$SLen > $MaxL} {set MaxL $SLen }
         set CurOpVal($i) "$PIDFsenpidfN($j)"
         incr i
      }
   }
   set MaxL [expr $MaxL + 2]
   if {$QuEsRBox($Qp) > $MaxL} {set MaxL $QuEsRBox($Qp) }
   GUIbuttonMenu $W "" grid|0|0 $Ops "GM_ProcessOpt $Pn $Qn 0" 0 $MaxL
}

proc GM_PIDFData { Pn Qn } { 
   global PaGeBase PIDFdatamask CurOpVal QuEsFrame QuEsCol
 
   set Qp [expr $PaGeBase($Pn) + $Qn]

   if { [string match opt* $QuEsFrame($Qp)] == 0 } {
      set m ".pg$Pn.$QuEsFrame($Qp).qs$Qn"
   } else {
      set m ".pg$Pn.$QuEsFrame($Qp).$QuEsCol($Qp).qs$Qn"
   } 
   regexp {0x(.)(.)} $PIDFdatamask M U L

   set i 0
   set Ops ""

   set A ""
   regexp {([13579BDFbdf])} $U M A
   if {[string length $A] > 0} { 
      lappend Ops Sensor
      set CurOpVal($i) 0
      incr i
   }

   set A ""
   regexp {([89ABCDEFabcdef])} $L M A
   if {[string length $A] > 0} { 
      lappend Ops Scan
      set CurOpVal($i) 1
      incr i
   }

   set A ""
   regexp {([4567CDEFcdef])} $L M A
   if {[string length $A] > 0} { 
      lappend Ops Ancillary
      set CurOpVal($i) 2
      incr i
   }

   set A ""
   regexp {([2367ABEFabef])} $L M A
   if {[string length $A] > 0} { 
      lappend Ops Mode
      set CurOpVal($i) 6
      incr i
   }

   set A ""
   regexp {([13579BDFbdf])} $L M A
   if {[string length $A] > 0} { 
      lappend Ops Quality
      set CurOpVal($i) 5
      incr i
   }

   set A ""
   regexp {([4567CDEFcdef])} $U M A
   if {[string length $A] > 0} { 
      lappend Ops "Phase Angle"
      set CurOpVal($i) 3
      incr i
   }

   set A ""
   regexp {([2367ABEFabef])} $U M A
   if {[string length $A] > 0} { 
      lappend Ops "Pitch Angle"
      set CurOpVal($i) 4
      incr i
   }
   GUIbuttonMenu $m "" grid|0|0 $Ops "GM_ProcessOpt $Pn $Qn 0"
}

proc GM_ReadPIDF { Fn PmEiV } {
   global PIDFnumgrps PIDFgrpnms PIDFplotavail PIDFdatamask PIDFnumsens \
          PIDFinstdeps PIDFcyclic PIDFminmax PIDFnumbinsets PIDFnumunits \
          PIDFnummodes PIDFnumscans PIDFRead PaGeBase QuEsCReply env \
          PIDFnumancs PIDFsentype

   if ![file exist $Fn] {
      set pList ""
      lappend pList SEARCHP
      lappend pList [lindex $PmEiV 0]
      lappend pList [lindex $PmEiV 1]
      lappend pList [lindex $PmEiV 2]
      lappend pList [lindex $PmEiV 3]
      lappend pList [lindex $PmEiV 4]
      lappend pList 1900
      lappend pList 1
      lappend pList 0
      lappend pList 2500
      lappend pList 1
      lappend pList 0
      lappend pList 3

      CLpPromote $pList
   }

   set FS [open $Fn r]

   set PIDFRead $Fn
   set field ""
   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
   set P2 {^[ ]*([^ ]*).([^ ]*)[ ="]*([^"]*)..(.*)}
   set P3 {^[ ]*([^ ]*).([A-Za-z]*)([0-9]*)(.*)}

   set PIDFplotavail 0x3 
   set PIDFdatamask  0x10
   set PIDFinstdeps   5
   set PIDFcyclic     N
   set PIDFminmax(0) -1
   set PIDFminmax(1) -1
   set PIDFminmax(2) -1
   set PIDFminmax(3) -1
   set PIDFminmax(4) -1
   set PIDFminmax(5) -1
   set PIDFnumbinsets -1
   set PIDFnumunits 0
   set PIDFnummodes 0
   set PIDFnumsens 0
   set PIDFnumscans 0
   set PIDFnumancs 0
   set PIDFsentype S

   set nG 0

   while {[gets $FS line] >= 0} {
      regexp "$P1" $line M type field var com
      if { [string match struct* $type] == 0 } { 
         switch -glob -- $field {
           num_groups*      {  set PIDFnumgrps $var }
           group_name*      {  regexp "$P2" $line M type field name com
                               set PIDFgrpnms($nG) $name
                               incr nG
                            }
           plot_avail_flag* {  set PIDFplotavail  $var }
           data_type_mask*  {  set PIDFdatamask   $var 
                               if ![string match *x* $PIDFdatamask] {
                                 set PIDFdatamask [format "0x%x" $PIDFdatamask]
                               }
                            }
           instrument_dep*  {  set PIDFinstdeps   $var }
           cyclic*          {  set PIDFcyclic     $var }
           sen_type*        {  set PIDFsentype    $var }
           phi_min*         {  set PIDFminmax(0)  $var }
           phi_max*         {  set PIDFminmax(1)  $var }
           theta_min*       {  set PIDFminmax(2)  $var }
           theta_max*       {  set PIDFminmax(3)  $var }
           scan_min*        {  set PIDFminmax(4)  $var }
           scan_max*        {  set PIDFminmax(5)  $var }
           num_bin_sets*    {  set PIDFnumbinsets $var }
           num_units*       {  set PIDFnumunits   $var }
           num_sensors*     {  set PIDFnumsens    $var }
           num_modes*       {  set PIDFnummodes   $var }
           num_scan*        {  set PIDFnumscans   $var }
           num_cals*        {  set PIDFnumancs    $var }
         }
      } else {
         regexp "$P3" $line M type field pos com
         switch -glob -- $field {
            Unit*     {GM_ReadUnit   $FS $pos}
            Sensor*   {GM_ReadSensor $FS $pos}
            Mode*     {GM_ReadMode   $FS $pos}
            Scan*     {GM_ReadScan   $FS $pos}
            CalSet*   {GM_ReadAnc    $FS $pos}
            DataQual* {GM_ReadDQ     $FS }
         }
      }
   }

   set PIDFnumgrps $nG
                                                                                
   close $FS
}

proc GM_ReadUnit {FS N} {
   global PIDFunitid  PIDFunitmin  PIDFunitmax  PIDFunitsca  PIDFunitlab \
          PIDFunitLdes  PIDFunitSdes  PIDFunitNtab  PIDFunittabs  PIDFunitops

   set PIDFunittabs($N) ""
   set PIDFunitops($N)  ""

   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
   set P2 {^[ ]*([^ ]*).([^ ]*)[ ="]*([^"]*)..(.*)}
   gets $FS line
   regexp "\[ \t\]*(.)" $line M end
   while {[string compare $end "\}"] != 0 } {
      regexp "$P1" $line M type field var com
      if { [string match string* $type] == 1 } { 
          regexp "$P2" $line M type field var com
      }
      if { [string match struct* $type] == 0 } { 
         switch -glob -- $field {
            id*                 {  set PIDFunitid($N)   $var       }
            min*                {  set PIDFunitmin($N)  $var       }
            max*                {  set PIDFunitmax($N)  $var       }
            unit_scaling*       {  set PIDFunitsca($N)  [expr $var - 1] }
            unit_label*         {  set PIDFunitlab($N)  $var       }
            long_description*   {  set PIDFunitLdes($N) $var       }
            short_description*  {  set PIDFunitSdes($N) $var       }
            num_tables*         {  set PIDFunitNtab($N) $var       }
            tbl_app_flag*       {  append PIDFunittabs($N) "$var " }
            tbl_app_oper*       {  append PIDFunitops($N)  "$var " }
         }
      }
      gets $FS line
      regexp "\[ \t\]*(.)" $line M end
   }
}
proc GM_ReadMode {FS N} {
   global PIDFmodename  PIDFmodeSname  PIDFmodepidfN  PIDFmodevidfN \
          PIDFmodeNunits  PIDFmodeunits

   set PIDFmodeNunits($N) 0
   set PIDFmodeunits($N)  ""

   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
   set P2 {^[ ]*([^ ]*).([^ ]*)[ ="]*([^"]*)..(.*)}
   set P3 {^[ ]*([^ ]*).([^ ]*)[ =']*([^']*)..(.*)}
   gets $FS line
   regexp "\[ \t\]*(.)" $line M end
   while {[string compare $end "\}"] != 0 } {
      regexp "$P1" $line M type field var com
      if { [string match string* $type] == 1 } { 
          regexp "$P2" $line M type field var com
      } elseif { [string match char* $type] == 1 } { 
          regexp "$P3" $line M type field var com
      }

      if { [string match struct* $type] == 0 } { 
         switch -glob -- $field {
            name*               {  set PIDFmodename($N)   $var      }
            short_name*         {  set PIDFmodeSname($N)  $var      }
            pidf_mode_num*      {  set PIDFmodepidfN($N)  $var      }
            vidf_mode_num*      {  set PIDFmodevidfN($N)  $var      }
            num_units*          {  set PIDFmodeNunits($N) $var      }
            unit_number*        {  append PIDFmodeunits($N) "$var " }
         }
      }
      gets $FS line
      regexp "\[ \t\]*(.)" $line M end
   }
}

proc GM_ReadSensor {FS N} {
   global PIDFsenname  PIDFsencomp  PIDFsensource  PIDFsenscffile \
          PIDFsenpa  PIDFsenpidfN  PIDFsenvidfN  PIDFsengrpN \
          PIDFsendspl  PIDFsenscanblk  PIDFsenNunits  PIDFsenunits

   set PIDFsenNunits($N) 0
   set PIDFsenunits($N)  ""
   set PIDFsenscanblk($N) -1

   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
   set P2 {^[ ]*([^ ]*).([^ ]*)[ ="]*([^"]*)..(.*)}
   set P3 {^[ ]*([^ ]*).([^ ]*)[ =']*([^']*)..(.*)}
   gets $FS line
   regexp "\[ \t\]*(.)" $line M end
   while {[string compare $end "\}"] != 0 } {
      regexp "$P1" $line M type field var com
      if { [string match string* $type] == 1 } { 
          regexp "$P2" $line M type field var com
      } elseif { [string match char* $type] == 1 } { 
          regexp "$P3" $line M type field var com
      }

      if { [string match struct* $type] == 0 } { 
         switch -glob -- $field {
            name*               {  set PIDFsenname($N)    $var      }
            component*          {  set PIDFsencomp($N)    $var      }
            source*             {  set PIDFsensource($N)  $var      }
            scf_filename*       {  set PIDFsenscffile($N) $var      }
            pitch_angle_flag*   {  set PIDFsenpa($N)      $var      }
            pidf_sensor_num*    {  set PIDFsenpidfN($N)   $var      }
            vidf_sensor_num*    {  set PIDFsenvidfN($N)   $var      }
            group_num*          {  set PIDFsengrpN($N)    $var      }
            display_flag*       {  set PIDFsendspl($N)    $var      }
            scan_block_info*    {  set PIDFsenscanblk($N) $var      }
            num_units*          {  set PIDFsenNunits($N)  $var      }
            unit_number*        {  append PIDFsenunits($N) "$var "  }
         }
      }
      gets $FS line
      regexp "\[ \t\]*(.)" $line M end
   }
}

proc GM_ReadAnc {FS N} {
   global PIDFancname  PIDFancSname  PIDFancpidfN  PIDFancvidfN  \
          PIDFancNunits  PIDFancunits PIDFancmodflag PIDFancsenN \
          PIDFNancsen

   set PIDFancNunits($N) 0
   set PIDFancunits($N)  ""
   set PIDFNancsen($N)  -1

   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
   set P2 {^[ ]*([^ ]*).([^ ]*)[ ="]*([^"]*)..(.*)}
   set P3 {^[ ]*([^ ]*).([^ ]*)[ =']*([^']*)..(.*)}
   gets $FS line
   regexp "\[ \t\]*(.)" $line M end
   while {[string compare $end "\}"] != 0 } {
      regexp "$P1" $line M type field var com
      if { [string match string* $type] == 1 } { 
          regexp "$P2" $line M type field var com
      } elseif { [string match char* $type] == 1 } { 
          regexp "$P3" $line M type field var com
      }

      if { [string match struct* $type] == 0 } { 
         switch -glob -- $field  {
            name*                {  set PIDFancname($N)      $var    }
            short_name*          {  set PIDFancSname($N)     $var    }
            pidf_cal_num*        {  set PIDFancpidfN($N)     $var    }
            vidf_cal_num*        {  set PIDFancvidfN($N)     $var    }
            num_units*           {  set PIDFancNunits($N)    $var    }
            unit_number*         {  append PIDFancunits($N) "$var "  }
            cal_modify_flag*     {  set PIDFancmodflag($N)   $var    }
            number_cal_sensors*  {  set PIDFNancsen($N)      $var    }
            cal_based_on_sensor* {  append PIDFancsenN($N)  "$var "  }
         }
      }
      gets $FS line
      regexp "\[ \t\]*(.)" $line M end
   }
}

proc GM_ReadScan {FS N} {
   global PIDFscanblkN  PIDFscanNunits  PIDFscanspace PIDFscanunits

   set PIDFscanBlkN($N)   0
   set PIDFscanNunits($N) 0
   set PIDFscanspace($N) ""
   set PIDFscanunits($N) ""

   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
   set P2 {^[ ]*([^ ]*).([^ ]*)[ ="]*([^"]*)..(.*)}
   set P3 {^[ ]*([^ ]*).([^ ]*)[ =']*([^']*)..(.*)}
   gets $FS line
   regexp "\[ \t\]*(.)" $line M end
   while {[string compare $end "\}"] != 0 } {
      regexp "$P1" $line M type field var com
      if { [string match string* $type] == 1 } { 
          regexp "$P2" $line M type field var com
      } elseif { [string match char* $type] == 1 } { 
          regexp "$P3" $line M type field var com
      }

      if { [string match struct* $type] == 0 } { 
         switch -glob -- $field {
            scan_block_num*  {  set PIDFscanblkN($N)    $var     }
            num_units*       {  set PIDFscanNunits($N)  $var     }
         }
      } else {
         gets $FS line
         set j 0
         while  {$j < $PIDFscanNunits($N) } {
             regexp "$P1" $line M type field var com
             switch -glob -- $field {
                spacing*      {  regexp {([A-Za-z])} $var M var
                                 append PIDFscanspace($N)  "$var " }
                units_index*  {  append PIDFscanunits($N)  "$var " }
             }
             gets $FS line
             regexp "\[ \t\]*(.)" $line M end
             if {[string compare $end "\}"] == 0 } {incr j}
         }
      }
      gets $FS line
      regexp "\[ \t\]*(.)" $line M end
   }
}

proc GM_ReadDQ {FS } {
   global PIDFdqname  PIDFdqSname  PIDFdqNunits  PIDFdqunits

   set PIDFdqNunits 0
   set PIDFdqunits  ""

   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
   set P2 {^[ ]*([^ ]*).([^ ]*)[ ="]*([^"]*)..(.*)}
   set P3 {^[ ]*([^ ]*).([^ ]*)[ =']*([^']*)..(.*)}
   gets $FS line
   regexp "\[ \t\]*(.)" $line M end
   while {[string compare $end "\}"] != 0 } {
      regexp "$P1" $line M type field var com
      if { [string match string* $type] == 1 } { 
          regexp "$P2" $line M type field var com
      } elseif { [string match char* $type] == 1 } { 
          regexp "$P3" $line M type field var com
      }

      if { [string match struct* $type] == 0 } { 
         switch -glob -- $field {
            name*               {  set PIDFdqname    $var      }
            short_name*         {  set PIDFdqSname   $var      }
            num_units*          {  set PIDFdqNunits  $var      }
            unit_number*        {  append PIDFdqunits "$var "  }
         }
      }
      gets $FS line
      regexp "\[ \t\]*(.)" $line M end
   }
}
