# THIS PROCEDURE STARTS UP THE PROGRAM ASSOCIATED WITH THE RUN BUTTONS ON
# THE CONTROL MENU.  THE PROCESS CAN EITHER BE STARTED IN FOREGROUND OR
# BACKGROUND.  THERE IS A SEPARATE BUTTON FOR PLOTTING TO TK CANVAS
# WHICH IS ONLY IMPLEMENTED IF A TKPLOT CAN BE MADE.
#
# NOTE -- THE CURRENT MENU IS SAVED PRIOR TO EXECUTION!!!!

package provide GMenu 1.0

proc GM_MenuExec { Ctrl } {
   global MeNuTemplates MeNuPages MeNuSave MeNuExec env tcl_platform \
          sP ExT SySCmDs

   GM_SaveMenu

   set Len [llength [split $MeNuExec :]]
   set PrgmName [lindex [split $MeNuExec :] [expr $Len - 1]]
   if { $Len > 1 } {
      for {set j 0} {$j < $Len} {incr j} {
         set Fld [lindex [split $MeNuExec :] $j]
         set Fc [string index $Fld 0]
         if { [string match "$" $Fc ] == 1 } {
              set Ev [string trimleft $Fld "$"]
              set Fld $env($Ev)
         }
         if { $j == 0 } {
            set RunPrgm $Fld
         } else {
            set RunPrgm [file join $RunPrgm $Fld]
         }
      }
   } else { set RunPrgm $MeNuExec }
   if { [string length $SySCmDs(ext)] > 0 } { append RunPrgm $SySCmDs(ext) }

   if { [string length $ExT] > 0 } {
      set mF $MeNuSave.$ExT
   } else { set mF $MeNuSave }

   set OpenMenu [file join $sP $mF]

   if {[string length $RunPrgm] > 0} { 
      switch -exact -- $Ctrl {
         0  { catch { exec $RunPrgm $OpenMenu } result 
              GM_DecodeErr $result
            }
         1  {  catch {exec $RunPrgm $OpenMenu &} result
               GM_DecodeErr $result
            }
         2  {  GM_TkPloT }
      }
   }
}
