# REPLACE TEMPLATE RELATIVE PAGES DESIGNATIONS

package provide GMenu 1.0

proc GM_ActPgReplace { Bn Pn Skip} {
   global QuEsSact QuEsNacts QuEsActInfo Abase PaGeParPg
  
   set rest "N";

   switch -exact -- $Skip {
     0 {  set rest $QuEsActInfo($Abase);                        } 
     1 {  regexp {([^ ]*) (.*)} $QuEsActInfo($Abase) M id rest  }
   }

   switch -glob -- $rest {
     B+* { regexp {[^C][^0-9]*([0-9]*).*} $rest M V R
           set Pg [expr $PaGeParPg($Bn) + $V]
           set V "B\\+$V"
         }
     C+* { regexp {[^C][^0-9]*([0-9]*).*} $rest M V R
           set Pg [expr $Pn + $V]
           set V "C\\+$V"
         }
     C-* { regexp {[^C][^0-9]*([0-9]*).*} $rest M V R
           set Pg [expr $Pn - $V]
           set V "C\\-$V"
         }
     C*  { set Pg $Pn
           set V "C"
         }
     P+* { regexp {[^P][^0-9]*([0-9]*).*} $rest M V R
           set Pg [expr $Bn + $V]
           set V "P\\+$V"
         }
     P-* { regexp {[^P][^0-9]*([0-9]*).*} $rest M V R
           set Pg [expr $Bn - $V]
           set V "P\\-$V"
         }
     P*  { set Pg $Bn
           set V "P"
         }
     N*  { set Skip 2 }
   }
          
   switch -exact -- $Skip {
     0 { regsub $V $QuEsActInfo($Abase) $Pg QuEsActInfo($Abase) }
     1 { regsub -all $V $rest $Pg rest 
         set QuEsActInfo($Abase) "$id $rest" 
       }
   }
}

# REPLACE TEMPLATE RELATIVE PAGES DESIGNATIONS

proc GM_CorRelPgs { Bn Pn N M } {
   global QuEsSact QuEsNacts QuEsActInfo QuEsAct \
          TQuEsSact TQuEsNacts TQuEsActInfo TQuEsAct \
          Abase

   set QuEsSact($N) $Abase
   set L $TQuEsSact($M) 

   for {set j 0} {$j < $TQuEsNacts($M) } {incr j} {
      set QuEsAct($Abase) $TQuEsAct($L)
      set QuEsActInfo($Abase) $TQuEsActInfo($L)
      if {[string length $QuEsActInfo($Abase)] > 0} {
         switch -glob -- $QuEsAct($Abase) {
             INVISIBLE* { GM_ActPgReplace  $Bn $Pn 0}
             VISIBLE*   { GM_ActPgReplace  $Bn $Pn 0}
             MUTE*      { GM_ActPgReplace  $Bn $Pn 0}
             ZERO*      { GM_ActPgReplace  $Bn $Pn 0}
             UDF*       { GM_ActPgReplace  $Bn $Pn 1}
             PIDF*      { GM_ActPgReplace  $Bn $Pn 1}
             EPUT*      { GM_ActPgReplace  $Bn $Pn 0}
             EMPUT*     { GM_ActPgReplace  $Bn $Pn 0}
             PUT*       { GM_ActPgReplace  $Bn $Pn 0}
             GET*       { GM_ActPgReplace  $Bn $Pn 0}
             SET*       { GM_ActPgReplace  $Bn $Pn 0}
             DOACTIVES* { GM_ActPgReplace  $Bn $Pn 0}
         }
      }
      incr Abase
      incr L
   }
}

# READ TEMPLATE PREFACE INFORMATION THROUGH THE TERMINATING LINE

proc GM_ReadTmplPreface { FD P BASE N} {
   global TmPlTitle TmPlNQues TmPlBase TmPlNumPAQ TmPlPAQ TmPlCWidth

   set TmPlBase($N)  $BASE
   set TmPlCWidth($N)  10
   set TmPlNumPAQ($N) 0
   set TmPlPAQ($N,0) 0
   while { [gets $FD line] >= 0 } {
      if { [string match |* $line ] == 1 } break
      regexp "$P$P$P" $line match VAR1 VAR2 VAR3

      switch -glob -- $VAR1 {
        QUESTIONS* { set TmPlNQues($N) $VAR2 }
        TITLE*     { set TmPlTitle($N) $VAR2 }
        CWIDTH*    { set TmPlCWidth($N) $VAR2 }
        PREACT*    { set TmPlPAQ($N,$TmPlNumPAQ($N)) $VAR2 
                     incr TmPlNumPAQ($N) 
                   }
      }
   }
}

# READ ALL QUESTION INFORMATION ASSOCIATES WITH TEMPLATE Tn

proc GM_ReadTQuesInfo { FD P Tn OPpos ACTpos} {
   global TQuEsLabel TQuEsGuide TQuEsHelp TQuEsRets TQuEsFmt TQuEsCReply \
          TQuEsNopts TQuEsSopt TQuEsNacts TQuEsSact TQuEsState\
          TQuEsOpts TQuEsAct TQuEsOval TQuEsActInfo TQuEsOpReply \
          TmPlBase TmPlNQues TQuEsRBox TQuEsQPos TQuEsQLoc TQuEsID \
          TQuEsColSpan TQuEsLPos TmPlCWidth TQuEsNoHelp

   set Msg "TEMPLATE PARSE ERROR - "
 
   for {set Qn 0} {$Qn < $TmPlNQues($Tn) } {incr Qn} {

      set N [expr $TmPlBase($Tn) + $Qn]

# SET UP DEFAULTS FOR FIELDS NOT DEFINED IN MENU FILE

      set TQuEsID($N) -1
      set TQuEsGuide($N) ""
      set TQuEsLabel($N) ""
      set TQuEsQLoc($N) "" 
      set TQuEsQPos($N) ""
      set TQuEsHelp($N) ""
      set TQuEsFmt($N) ""
      set TQuEsCReply($N) ""
      set TQuEsRets($N) 0
      set TQuEsNopts($N) 0
      set TQuEsNacts($N) 0
      set TQuEsNoHelp($N) 0
      set TQuEsSopt($N) $OPpos
      set TQuEsSact($N) $ACTpos
      set TQuEsState($N) 1
      set TQuEsColSpan($N) 1
      set TQuEsOpReply($N) ""
      set TQuEsRBox($N) $TmPlCWidth($Tn)
      set TQuEsLPos($N) ""

      while { [gets $FD line] >= 0 } {
         if { [string match |* $line ] == 1 } break
         regexp "$P$P$P$P$" $line match VAR1 VAR2 VAR3 VAR4 
 
         switch -glob -- $VAR1 {
            ID*      { set TQuEsID($N)       $VAR2     }
            LABEL*   { set TQuEsLabel($N)    $VAR2     }
            HELP*    { set TQuEsHelp($N)     $VAR2     } 
            NOHELP*  { set TQuEsNoHelp($N)   $VAR2     } 
            GUIDE*   { set TQuEsGuide($N)    $VAR2     }
            RNUM*    { set TQuEsRets($N)     $VAR2     }
            FMT*     { set TQuEsFmt($N)      $VAR2     }
            QLOC*    { set TQuEsQLoc($N)     $VAR2     }
            QPOS*    { set TQuEsQPos($N)     $VAR2     }
            STATE*   { set TQuEsState($N)    $VAR2     }
            OPREPLY* { set TQuEsOpReply($N)  $VAR2     }
            RBOX*    { set TQuEsRBox($N)     $VAR2     }
            CSPAN*   { set TQuEsColSpan($N)  $VAR2     }
            LPOS*    { set TQuEsLPos($N)     $VAR2     }
            CREPLY*  { set TQuEsCReply($N)   $VAR2     }
            OPTION*  {  if {[string length $VAR3] > 0 } {
                           set TQuEsOpts($OPpos) $VAR2 
                           set TQuEsOval($OPpos) $VAR3   
                           incr OPpos 
                           incr TQuEsNopts($N)
                        } else {
                           set Ops [split $VAR2 : ]
                           set NOps [llength $Ops ]
                           for { set OpN 0 } { $OpN < $NOps } { incr OpN } {
                              set OP [split [lindex $Ops $OpN] | ]
                              set TQuEsOpts($Obase) [lindex $OP 0]
                              set TQuEsOval($Obase) [lindex $OP 1]
                              incr OPpos
                              incr TQuEsNopts($N)
                           }
                        }
                     }
            ACTINFO* { set TQuEsAct($ACTpos) $VAR2 
                       set TQuEsActInfo($ACTpos) $VAR3    
                       incr ACTpos
                       incr TQuEsNacts($N)             }
         }
      }
   }
}
