package provide GMenu 1.0

proc GM_LoadMenu { } {
   global MeNuLoad MeNuPages MeNuTemplates PaGeNQues FD \
          QuEsNacts QuEsNopts QuEsSact QuEsSopt PaGeTitle MeNuTNums\
          TQuEsNacts TQuEsNopts TQuEsSact TQuEsSopt TmPlNQues MeNuTFile\
          Qbase Obase Abase MaxOnCtrl PaGeATitle env MenuLoaded \
          MeNuSave bP ExT MExts ActiveLB
          
   set P  "(\[^\t\]*)\t*"
   set Qbase 0
   set Obase 0
   set Abase 0
   set Tqbase 0
   set Tobase 0
   set Tabase 0

   if { [string length $MeNuLoad] == 0 } {
      GUImsgPopUp .tHeMsG -1 -1 [list "No Defined Menu File"]
      tkwait window .tHeMsG
      set bP [pwd] 
      return 
   }

   if { [string length $ExT] == 0 } {
      set End [expr [llength [split $MeNuLoad .]] - 1]
      if { $End > 0 } {
         set PExT "[lindex [split $MeNuLoad .] $End]"
         if { [lsearch $MExts $PExT] >= 0 } {
            set ExT $PExT
            set MeNuLoad "[lindex [split $MeNuLoad .] 0]"
            for {set i 1} {$i < $End} {incr i} {
               append MeNuLoad ".[lindex [split $MeNuLoad .] $i]"
            }
         }
      }
   }

   if { [string length $ExT] > 0 } {
      set End [expr [llength [split $MeNuSave .]] - 1]
      if { $End > 0 } {
         set PExT "[lindex [split $MeNuSave .] $End]"
         if { [string match $ExT $PExT] == 1 } {
            set MeNuSave "[lindex [split $MeNuSave .] 0]"
            for {set i 1} {$i < $End} {incr i} {
               append MeNuSave ".[lindex [split $MeNuSave .] $i]"
            }
         }
      }
   }

   if {$MeNuPages > 0} { GM_DeleteAll ; GM_StartUp ; set MenuLoaded 0} 

   if { [string length $ExT] > 0 } {
      set mF $MeNuLoad.$ExT
   } else { set mF $MeNuLoad }

   set Fn [file join $bP $mF]
   if { [file exists $Fn] == 1 } {
      set FD [open $Fn r]
   } else {
      set bP [file join $env(UDFTOOL_HOME) GMenu Templates]
      set fN [file join $bP $mF ]
      if { [file exists $fN] == 1 } {
         set FD [open $fN r]
      } else { 
         GUImsgPopUp .tHeMsG -1 -1 [list "No Menu File" "" \
                 "Unable To Locate Menu File:" $Fn or $fN]
         tkwait window .tHeMsG
         set bP [pwd] 
         return 
      }
   }

   GM_ReadMenuPreface $FD $P
   if {$MeNuTemplates > 0} { 
      GM_ReadTemplateInfo $FD $P 
      for {set i 0} {$i < $MeNuTemplates} {incr i} {
         set Tn $MeNuTNums($i)

         set Fn [ file join $bP $MeNuTFile($i) ]
         if { [file exists $Fn] == 1 } {
            set FT [open $Fn r]
         } else {
            set THome [file join $env(UDFTOOL_HOME) GMenu Templates]
            set fN [file join $THome $MeNuTFile($i)]
            if { [file exists $fN] == 1 } {
               set FT [open $fN r]
            } else { 
               GUImsgPopUp .tHeMsG -1 -1 [list "No Template File" "" \
                 "Unable To Locate Menu File:" $Fn or $fN]
               tkwait window .tHeMsG
               set bP [pwd] 
               return 
            }
         }

         GM_ReadTmplPreface $FT $P $Tqbase $Tn
         GM_ReadTQuesInfo $FT $P $Tn $Tobase $Tabase
         set N [expr $Tqbase + $TmPlNQues($Tn) - 1]
         set Tqbase [expr $TmPlNQues($Tn) + $Tqbase]
         set Tobase [expr $TQuEsSopt($N) + $TQuEsNopts($N) + $Tobase]
         set Tabase [expr $TQuEsSact($N) + $TQuEsNacts($N) + $Tabase]
         close $FT
      }
   }

   for {set Pn 0} {$Pn < $MeNuPages} {incr Pn} {
      GM_ReadPagePreface $FD $P
      GM_ReadQuesInfo $FD $P $Pn
      
      $ActiveLB insert end $PaGeATitle($Pn)
      if {$Pn == 0} { $ActiveLB selection set end } 
      GM_ActiveLB

      if {$Pn == 0} { GM_DisplayMenu $Pn 1 } else { GM_DisplayMenu $Pn 0 }
   }
   close $FD
   set MenuLoaded 1
}

# READ MENU PREFACE INFORMATION THROUGH THE TERMINATING LINE


proc GM_ReadMenuPreface { FD P } {
   global MeNuTemplates MeNuPages MeNuSave MeNuExec MeNuTkPlot \
          MeNuCom1 MeNuCom2 Prefs

   set MeNuExec ""
   set MeNuTkPlot ""
   set MeNuTemplates 0
   set MeNuCom1 ""
   set MeNuCom2 ""
   set CoL 4
   while { [gets $FD line] >= 0 } {
      if { [string match |* $line ] == 1 } break
      regexp "$P$P" $line match VAR1 VAR2

      switch -glob -- $VAR1 {
         TEMPLATES* { set MeNuTemplates $VAR2 }
         PAGES*     { set MeNuPages $VAR2 }
         RUN*       { set MeNuExec $VAR2 }
         TKPLOT*    { set MeNuTkPlot $VAR2 }
         COM1*      { set MeNuCom1 $VAR2 }
         COM2*      { set MeNuCom2 $VAR2 }
      }
   }

   if ![winfo exists .gmTOP.c.runbg] {
      if {[string length $MeNuExec] > 0} { 
         GUIbuttonPush .gmTOP.c.runbg "Run\nBkGnd" pack|left "GM_MenuExec 1" 6
         GUIbuttonPush .gmTOP.c.runfg "Run\nFrGnd" pack|left "GM_MenuExec 0" 6
      }
   }

   if ![winfo exists .gmTOP.c.runtk] {
      if {[string length $MeNuTkPlot] > 0} { 
         GUIbuttonPush .gmTOP.c.runtk "Run\nTkWin" pack|left "GM_MenuExec 2" 6
      }
   }
}

# READ THE DEFINED TEMPLATE FILES

proc GM_ReadTemplateInfo { FD P } {
   global MeNuTemplates MeNuPages MeNuSave MeNuTFile MeNuTNums

   set NT 0
   while { [gets $FD line] >= 0 } {
      if { [string match |* $line ] == 1 } {break}
      regexp "$P$P$P" $line match VAR1 VAR2 VAR3

      set MeNuTFile($NT) $VAR2
      set MeNuTNums($NT) $VAR3
      incr NT
   }

   if {$NT != $MeNuTemplates} {
      puts stderr "MENU PARSE ERROR - MISSING OR EXTRA TEMPLATES"
      exit
   }
}

proc GM_ReadPagePreface { FD P } {
   global PaGeTitle PaGeNQues PaGeBase Qbase PaGeParPg PaGeParQs \
          PaGeCWidth PaGeATitle

   set Msg "MENU PARSE ERROR - "

   if { [gets $FD line] >= 0 } {
      regexp "$P$P$P" $line match VAR1 N VAR3
      if ![string match PAGE $VAR1] {
         puts stderr "$Msg PAGE NUMBER NOT FIRST ENTRY IN PAGE PREFACE"
         exit
      }
   } else {
      puts stderr "$Msg NO ENTRIES IN PAGE PREFACE"
      exit
   }
             
   set PaGeBase($N)  $Qbase
   set PaGeCWidth($N) 10
   set PaGeTitle($N)  ""
   set PaGeATitle($N) ""
   set PaGeParPg($N)  -1
   set PaGeParQs($N)  -1
   while { [gets $FD line] >= 0 } {
      if { [string match |* $line ] == 1 } break
      regexp "$P$P$P" $line match VAR1 VAR2 VAR3

      switch -glob -- $VAR1 {
        QUESTIONS* { set PaGeNQues($N) $VAR2 }
        TITLE*    { set PaGeTitle($N) $VAR2  }
        CWIDTH*   { set PaGeCWidth($N) $VAR2 }
        PARPG*    { set PaGeParPg($N) $VAR2 }
        PARQS*    { set PaGeParQs($N) $VAR2 }
      }
   }
   
   set End [ expr 20 - [string length $PaGeTitle($N)]]
   set TmP $PaGeTitle($N)
   for {set i 0} { $i < $End } {incr i} { append TmP " " }

   set PaGeATitle($N) "$TmP \[$PaGeParPg($N).$N\]"
   set Qbase [expr $Qbase + $PaGeNQues($N)]
}

# READ ALL QUESTION INFORMATION ASSOCIATES WITH MENU PAGE Pn

proc GM_ReadQuesInfo { FD P Pn } {
   global QuEsLabel QuEsGuide QuEsHelp QuEsRets QuEsFmt QuEsCReply \
          QuEsNopts QuEsSopt QuEsNacts QuEsSact QuEsState QuEsNWins\
          QuEsOpts QuEsAct QuEsOval QuEsActInfo QuEsOpReply QuEsWns\
          PaGeBase PaGeNQues Abase Obase QuEsRBox QuEsAltVal QuEsNumTVal\
          QuEsQLoc QuEsQPos QuEsRow QuEsCol QuEsID AdvMRow AdvURow \
          QuEsLPos QuEsColSpan PaGeCWidth QuEsNoHelp AdvOCol

   set Msg "QUESTION PARSE ERROR - "
   set AdvMRow 0
   set AdvURow 0
   set AdvOCol 0
 
   for {set Qn 0} {$Qn < $PaGeNQues($Pn) } {incr Qn} {

      set N [expr $PaGeBase($Pn) + $Qn]

# SET UP DEFAULTS FOR FIELDS NOT DEFINED IN MENU FILE

      set QuEsID($N) -1
      set QuEsGuide($N) ""
      set QuEsQLoc($N) "" 
      set QuEsQPos($N) ""
      set QuEsLabel($N) ""
      set QuEsHelp($N) ""
      set QuEsFmt($N) ""
      set QuEsCReply($N,0) ""
      set QuEsRets($N) 0
      set QuEsNopts($N) 0
      set QuEsNumTVal($N) 0
      set QuEsNacts($N) 0
      set QuEsNoHelp($N) 0
      set QuEsSopt($N) $Obase
      set QuEsSact($N) $Abase
      set QuEsState($N) 1
      set QuEsColSpan($N) 1
      set QuEsOpReply($N) ""
      set QuEsNWins($N) 0
      set QuEsWns($N) ""
      set QuEsRBox($N) $PaGeCWidth($Pn)
      set QuEsAltVal($N) ""
      set QuEsLPos($N) ""
      set Reply ""

      while { [gets $FD line] >= 0 } {
         if { [string match |* $line ] == 1 } break
         set VAR3 ""
         regexp "$P$P$P$P$" $line match VAR1 VAR2 VAR3 VAR4 
 
         switch -glob -- $VAR1 {
            ID*      { set QuEsID($N)       $VAR2     }
            LABEL*   { set QuEsLabel($N)    $VAR2     }
            HELP*    { set QuEsHelp($N)     $VAR2     }
            NOHELP*  { set QuEsNoHelp($N)   $VAR2     }
            GUIDE*   { set QuEsGuide($N)    $VAR2     }
            RNUM*    { set QuEsRets($N)     $VAR2     }
            FMT*     { set QuEsFmt($N)      $VAR2     }
            QLOC*    { set QuEsQLoc($N)     $VAR2     }
            QPOS*    { set QuEsQPos($N)     $VAR2     }
            STATE*   { set QuEsState($N)    $VAR2     }
            OPREPLY* { set QuEsOpReply($N)  $VAR2     }
            NWINS*   { set QuEsNWins($N)    $VAR2     }
            ALTVAL*  { set QuEsAltVal($N)   $VAR2     }
            RBOX*    { set QuEsRBox($N)     $VAR2     }
            LPOS*    { set QuEsLPos($N)     $VAR2     }
            CSPAN*   { set QuEsColSpan($N)  $VAR2     }
            WINS*    { set QuEsWns($N)      $VAR2     }
            CREPLY*  { set Reply            $VAR2     }
            OPTION*  {  if {[string length $VAR3] > 0 } {
                           set QuEsOpts($Obase) $VAR2 
                           set QuEsOval($Obase) $VAR3   
                           incr Obase
                           incr QuEsNopts($N)             
                        } else {
                           set Ops [split $VAR2 : ]
                           set NOps [llength $Ops ]
                           for { set OpN 0 } { $OpN < $NOps } { incr OpN } {
                              set OP [split [lindex $Ops $OpN] | ]
                              set QuEsOpts($Obase) [lindex $OP 0]
                              set QuEsOval($Obase) [lindex $OP 1]   
                              incr Obase
                              incr QuEsNopts($N)             
                           }
                        }
                     } 

            ACTINFO* { set QuEsAct($Abase) $VAR2 
                       set QuEsActInfo($Abase) $VAR3    
                       incr Abase
                       incr QuEsNacts($N)             }
         }
      }

      if {[string length $Reply] > 0} {
         string trimright $Reply " \t"
         set Rest $Reply
         set j 0
         if {$QuEsRets($N) > 1} {
            regexp {([^\|]*)\|(.*)} $Rest M V Rest
            set QuEsCReply($N,$j) $V
            set End [expr $QuEsRets($N) - 1]
            for {set j 1} {$j < $End } {incr j} {
                regexp {([^\|]*)\|(.*)} $Rest M V Rest
                set QuEsCReply($N,$j) $V
            }
         } 
         set QuEsCReply($N,$j) $Rest
      } 

      GM_SetLocation $N
   }
}
