# THIS PROCEDURE DETERMINES WHICH COLORTABLES ARE SUPPORTED IN THE
# GRAPHICS PACKAGE

package provide GMenu 1.0

proc GM_GCtbl { Pn Qn } { 
   global env PaGeBase QuEsSopt QuEsCReply QuEsNopts QuEsOpts QuEsOval \
          QuEsOpReply QuEsAct QuEsSact QuEsActInfo CurOpVal QuEsFrame \
          QuEsRBox QuEsCol Prefs

   set Qp [expr $PaGeBase($Pn) + $Qn]
   set QuEsOpReply($Qp) -1

   set Prg [file join $env(GPH_HOME) ctable COLORBARS]
   set fd [GM_FOpen stderr $Prg r]
   set Opts [read -nonewline $fd]
   close $fd

   if { [string match opt* $QuEsFrame($Qp)] == 0 } {
      set Wb ".pg$Pn.$QuEsFrame($Qp).qs$Qn"
      set W  ".pg$Pn.$QuEsFrame($Qp).qs$Qn.menu"
   } else {
      set Wb ".pg$Pn.$QuEsFrame($Qp).$QuEsCol($Qp).qs$Qn"
      set W  ".pg$Pn.$QuEsFrame($Qp).$QuEsCol($Qp).qs$Qn.menu"
   } 

   set MaxL 1
   set cN ""
   regexp "(\[^\n\]*)\n(.*)" $Opts M Ndev Opts
   set EnD [expr $Ndev - 1]
   for {set j 0} {$j < $EnD } {incr j} {
      regexp "(\[^\n\]*)\n(.*)" $Opts M line Opts
      regexp {([^:]*):(.*)} $line M name tbl
      lappend cN $name
      set SLen [string length $name]
      if {$SLen > $MaxL} {set MaxL $SLen }
      set CurOpVal($j) $tbl
   }
   regexp {([^:]*):(.*)} $Opts M name tbl
   lappend cN $name
   set SLen [string length $name]
   if {$SLen > $MaxL} {set MaxL $SLen }
   set CurOpVal($j) $tbl

   set MaxL [expr $MaxL + 2]
   if {$QuEsRBox($Qp) > $MaxL} {set MaxL $QuEsRBox($Qp) }
   GUIbuttonMenu $Wb "" grid|0|0 $cN "GM_ProcessOpt $Pn $Qn 0" 0 $MaxL
}

# THIS PROCEDURE CALLS THE GDevice PROGRAM AND TAKES ITS INPUT TO FORM
# A SET OF OPTIONS WHICH ARE THE POSSIBLE GRAPHICS DEVICES

proc GM_GDevices { Pn Qn } { 
   global env PaGeBase QuEsSopt QuEsCReply QuEsNopts QuEsOpts QuEsOval \
          QuEsOpReply QuEsAct QuEsSact QuEsActInfo CurOpVal QuEsFrame \
          QuEsRBox QuEsCol env tcl_platform Prefs SySCmDs

   set Qp [expr $PaGeBase($Pn) + $Qn]
   set QuEsOpReply($Qp) -1

   set Prg [file join $env(GPH_HOME) ancillary Gdevices]
   if { [string length $SySCmDs(ext)] > 0 } { append Prg $SySCmDs(ext) }

   if { [string match macintosh* $tcl_platform(platform)] == 1 } {
        set ProgScript [file join $env(GPH_HOME) ancillary Gdevices_scr]
        set token [AppleScript load $ProgScript]
        AppleScript run $token
        set fd [GM_FOpen stderr [file join $env(GPH_HOME) ancillary stdout] r]
        set Opts [read $fd]
        close $fd
   } else { set Opts [exec $Prg]  }

   if { [string match opt* $QuEsFrame($Qp)] == 0 } {
      set Wb ".pg$Pn.$QuEsFrame($Qp).qs$Qn"
      set W  ".pg$Pn.$QuEsFrame($Qp).qs$Qn.menu"
   } else {
      set Wb ".pg$Pn.$QuEsFrame($Qp).$QuEsCol($Qp).qs$Qn"
      set W  ".pg$Pn.$QuEsFrame($Qp).$QuEsCol($Qp).qs$Qn.menu"
   } 

   set MaxL 1
   set dN ""
   regexp "(\[^\n\]*)\n(.*)" $Opts M Ndev Opts
   set EnD [expr $Ndev - 1]
   for {set j 0} {$j < $EnD } {incr j} {
      regexp "(\[^\n\]*)\n(.*)" $Opts M line Opts
      regexp {([^:]*):([^:]*):(.*)} $line M dev pos T
      lappend dN $dev
      set SLen [string length $dev]
      if {$SLen > $MaxL} {set MaxL $SLen }
      set CurOpVal($j) $pos
   }
   regexp {([^:]*):([^:]*):(.*)} $Opts M dev pos T
   lappend dN $dev
   set SLen [string length $dev]
   if {$SLen > $MaxL} {set MaxL $SLen }
   set CurOpVal($j) $pos

   set MaxL [expr $MaxL + 2]
   if {$QuEsRBox($Qp) > $MaxL} {set MaxL $QuEsRBox($Qp) }
   GUIbuttonMenu $Wb "" grid|0|0 $dN "GM_ProcessOpt $Pn $Qn 0" 0 $MaxL
}
