
# THIS PROCEDURE DETERMINES THE FULL DATABASE PATH NAME

package provide GMenu 1.0

proc GM_DbPath { P M E I } {
   global env BaseDbPath DbPaths NDbSpec DbSpecID DbSpecPath 

   if { $DbPaths == 0 } { 
        GM_GetDbPaths 
        set DbPaths 1
   } 

   set pmeiv "$P:$M:$E:$I" 
   set Comps [split $pmeiv :]]

   for {set j 0} {$j < $NDbSpec } {incr j} {
      set ToMatch $P
      set Len [llength [split $DbSpecID($j) :]]
      set J 1
      while { $J < $Len } {
         append ToMatch ":[lindex $Comps $J]"
         incr J
      }
      if {[string match $ToMatch $DbSpecID($j)] == 1 } { break }
   }

   if {$j < $NDbSpec} {
      if {[string match "$*" $DbSpecPath($j)] == 1} {  
         regexp {\$([^/]*).(.*)} $DbSpecPath($j) Ma En rest
         set path $env($En)
         regexp {([^%]*)} $rest Ma rest 
         set Paths [file split $rest]
         set Dirs [llength $Paths]
         for {set i 0} { $i < $Dirs } { incr i } {
             set path [file join $path [lindex $Paths $i]]
         }
      } else { 
          regexp {([^%]*)} $DbSpecPath($j) Ma rest 
          set Paths [file split $rest]
          set Dirs [llength $Paths]
          set path ""
          for {set i 0} { $i < $Dirs } { incr i } {
             set path [file join $path [lindex $Paths $i]]
          }
      }
   } else {
      if {[string match "\$*" $BaseDbPath] == 1} {  
         regexp {\$(.*)} $BaseDbPath Ma En
         set path [file join $env($En) $P $M $E $I]
      }
   }
   set path [file join $path "Database" ]
   return $path
}
