package provide GMenu 1.0

proc GM_DbSkipLine { FS } {
   
    while {[gets $FS line] >= 0} {
      regexp "\[ \t\n\]*(.*)" $line M rest
      if {[string length $rest] == 0} { continue }
      if {[string index $line 0] != "#" } {return $line }
    }

    return ""
} 

proc GM_DbMkList { FS line rest} {

   regexp {[^A-Za-z_0-9-]*([A-Za-z_0-9-]*)(.*)} $rest M V rest
   while {[string length $V] > 0 } {
      lappend NLIST $V
      regexp {[^A-Za-z_0-9-]*([A-Za-z_0-9-]*)(.*)} $rest M V rest
   }

   while {[string match {*\\} $line] == 1 } {
      set line [GM_DbSkipLine $FS]
      regexp {[^A-Za-z_0-9-]*([A-Za-z_0-9-]*)(.*)} $line M V rest
      while {[string length $V] > 0 } {
         lappend NLIST $V
         regexp {[^A-Za-z_0-9-]*([A-Za-z_0-9-]*)(.*)} $rest M V rest
      }
   }

   return $NLIST
}

proc GM_GetDbInfo { } {
   global PROJECTS DbRead env

   GM_GetDbPaths
   set Db [file join $env(UDF_HOME) config PROJECTS.cfg]
   set FS [open $Db r]
   set DbRead 1
   set line [GM_DbSkipLine $FS]
   regexp {([A-Za-z]*)(.*)} $line M hdr rest

   while {[string match "Strings*" $hdr] == 0 } {
      set line [GM_DbSkipLine $FS]
      regexp {([A-Za-z]*)(.*)} $line M hdr rest
   }

   set PROJECTS [GM_DbMkList $FS $line $rest]

   set line [GM_DbSkipLine $FS]
   while {[string length $line] > 0 } {
      set j  0
      regexp "(\[^\.\t \]*).(.*)" $line M V1 rest
      while {[string match "Strings*" $V1] == 0 } {
         if { $j == 0 } { 
            set Nm $V1
         } else {
            append Nm ".$V1"
         }
         incr j
         regexp "(\[^\.\t \]*).(.*)" $rest M V1 rest
      }

      global [set Nm]
      set [set Nm] [GM_DbMkList $FS $line $rest]
      set line [GM_DbSkipLine $FS]
   }

   close $FS
}

# Find all possible paths
#
#  BasePidfPath - endemic PIDF path - used if specific path not set up
#  BaseDbPath   - endemic Database path - used if specific path not set up
#  BaseDataPath - endemic UDF Data path - used if specific path not set up
#  NPidfSpec    - number of specific Pidf paths found 
#  NDbSpec      - number of specific Database paths found
#  NDataSpec     - number of specific UDF data paths found
#  PidfSpecID   - the specific Pidf path ID 
#  PidfSpecPath - the specific Pidf path  
#  DbSpecID     - the specific Database path ID 
#  DbSpecPath   - the specific Database path  
#  DataSpecID   - the specific UDF Data path ID 
#  DataSpecPath - the specific UDF Data path  

proc GM_GetDbPaths { } {
   global env BasePidfPath BaseDbPath BaseDataPath DbPaths \
              NPidfSpec NDbSpec NDataSpec \
              PidfSpecID DbSpecID DataSpecID \
              PidfSpecPath DbSpecPath DataSpecPath \

   if {$DbPaths == 1 } { return }
   set Db [file join $env(UDF_HOME) config DB.cfg]
   set FS [open $Db r]

   set AllFound 0
   while { $AllFound < 3 } {  
      set line [GM_DbSkipLine $FS]
      regexp {([^\.]*).([A-Za-z]*)[ "]*([^"]*)} $line M V ID Path
      if { [string match PidfPath* $V] == 1 } {
         set BasePidfPath $Path
         incr AllFound
      }
      if { [string match DatabasePath* $V] == 1 } {
         set BaseDbPath $Path
         incr AllFound
      }
      if { [string match PostTimePath* $V] == 1 } {
         set BaseDataPath $Path
         incr AllFound
      }
   }

   set i 0
   set j 0
   set k 0
   set line [GM_DbSkipLine $FS]
   while {[string length $line] > 0 } {
      regexp {([^\.]*).([^\.]*).([A-Za-z]*)[ "]*([^"]*)} $line M I V ID Path
      if {[string match PidfPath* $V] == 1} {
         set PidfSpecID($i) $I
         set PidfSpecPath($i) $Path
         incr i
      }
      if {[string match DatabasePath* $V] == 1} {
         set DbSpecID($j) $I
         set DbSpecPath($j) $Path
         incr j
      }
      if {[string match PostTimePath* $V] == 1} {
         set DataSpecID($k) $I
         set DataSpecPath($k) $Path
         incr k
      }
      set line [GM_DbSkipLine $FS]
   }
   set NPidfSpec $i
   set NDbSpec $j
   set NDataSpec $k
   close $FS
}
