# CREATE A NEW MENU PAGE FROM A TEMPLATE

# INPUTS ARE THE PARENT PAGE NUMBER, THE PARENT QUESTION NUMBER AND
# WHETHER THE PAGE SHOULD BE CREATED AS VISIABLE OR INVISIBLE

package provide GMenu 1.0

proc GM_CreatePage { Pn Qn Vis} {
   global MeNuPages MeNuMaxPg QuEsSact QuEsActInfo PaGeBase PaGeATitle \
          QuEsNWins QuEsWns PaGeParPg PaGeParQs MaxOnCtrl \
          TmPlNumPAQ TmPlPAQ ActiveLB

   set Qp [expr $PaGeBase($Pn) + $Qn]
   set Np $MeNuMaxPg
   set Ap $QuEsSact($Qp)

   set P1 {([^ ]*) *}
   regexp "$P1$P1" $QuEsActInfo($Ap) match Tn Mx 

   if { $QuEsNWins($Qp) < $Mx } {
      incr MeNuPages 
      GM_TmplToPage $Pn $Tn $Np $Qn
      set PaGeParPg($Np) $Pn
      set PaGeParQs($Np) $Qn
      if {$Mx > 1} {
         set Title "[expr $QuEsNWins($Qp) + 1] DEFINED"
         .pg$Pn.user.right$Qn configure -text $Title -font default
      } 

      $ActiveLB insert end $PaGeATitle($Np)
      if {$Vis == 1} { $ActiveLB selection set end } 
      GM_ActiveLB

      GM_DisplayMenu $Np $Vis
      lappend QuEsWns($Qp) $Np
      incr QuEsNWins($Qp)
  
      if { $TmPlNumPAQ($Tn) > 0 } {
         for {set j 0} {$j < $TmPlNumPAQ($Tn) } {incr j} {
             GM_DoActives $Np $TmPlPAQ($Tn,$j)
         }
      }
   }
}
