# THIS procedure promotes the requested VIDF file.  The VIDF is promoted
#   regardless if there is a current file on the system or not.

package provide Client 1.0

proc CLvPromote { pList { sTmO 15000 } } {
   global SySCmDs PromoteList env UDFPaths

# FORM the request iD

   set PROJECT [lindex $pList 1] 
   set MISSION [lindex $pList 2] 
   set EXPERIMENT [lindex $pList 3] 
   set iD $PROJECT.$MISSION.$EXPERIMENT.V

# NOW parse the ClientInfo directory to see if we know if any Servers who
#   are providing this data.

   set cN [CLserverFind $iD cID sIP sPort sSrc sCom]

# SAVE the orginal request list.  

   set oList $pList

# THIS is the popup window control flag

   set DoWin  [lindex $pList 12]

# OBTAIN all of the necessary local UDF paths for this data set.  The
#    paths are returned in the global array variable UDFPaths.  The
#    definitions are:
#          UDFPaths(0) : the PIDF directory
#          UDFPaths(1) : the Database directory
#          UDFPaths(2) : the HD Data directory

   UDFdirPaths [lindex $pList 1] [lindex $pList 2] \
               [lindex $pList 3] [lindex $pList 4]

# FORM the VIDF directory which is on the same level as the PIDF directory.

   set dIr [file split $UDFPaths(0)]
   set dLen [expr [llength $dIr] - 1]
   set vDir [file join [lindex $dIr 0]] 
   for { set I 1 } { $I < $dLen } { incr I } { 
      set vDir [file join $vDir [lindex $dIr $I]]
   }
   set vDir [file join $vDir VIDFS]

#  NOW loop over the possible servers and try them 1 by 1 quitting when 
#     the data gets promoted.  The swtich allows for different data sources

   set NoData 1
   set I 0
   while { $NoData && ($I < $cN) } {
      switch -exact -- $sSrc($I) {
         UDF { CLudfvPromote $pList $sIP($I) $sPort($I) dBGen fComp $sTmO }
         IDFS { CLidfsvPromote $pList $sIP($I) $sPort($I) dBGen fComp }
      }

# MAKE the binary files from the  promoted data and then get everything to
#   where its supposed to be.  

      set NewGen ""
      set Len [llength $dBGen] 
      if { $Len > 0 } { CLmakeDTree "" "" "" "" UDFPaths } 
      for {set J 0} { $J < $Len } { incr J } {
         set vF [lindex $dBGen $J]
         set vName [file join $vDir ${vF}V]
         set iName [file join $UDFPaths(2) ${vF}I]
         if {[lindex $fComp $J] > 0} { 
            if [catch { exec $SySCmDs(gzip) -df ${vF}V.gz } OuT ] {
                file delete -force ${vF}V.gz
		set OK 0
            } else { set OK 1 } 
         } else { set OK 1 }
	 if $OK {
            DBvidfToBinary $vF
	    if [file exists ${vF}I] {
               file rename -force ${vF}I $iName
               file rename -force ${vF}V $vName
	       lappend NewGen $vF
	    }
         }
      }

# NOW generate the database entries for the promoted data and stick them
#   into the database

      set dBGen $NewGen
      set Len [llength $dBGen]
      if { $Len > 0 } { 
         set NoData 0
         set dbE [file join $UDFPaths(1) I.asc]
         set dBdbf [file join $UDFPaths(1) [lindex $pList 4].I.DBF]
         set dBndx [file join $UDFPaths(1) [lindex $pList 4].I.NDX]
         DBgenEntries I $UDFPaths(2) $UDFPaths(2) $dbE $dBGen
         set ePos [DBdbfAppend $dBdbf $dbE]
         DBndxAppend $dBndx $dbE $ePos
         file delete -force $dbE
      } else {
         if { $DoWin == 3 } { 
            ProPopUps $oList $sIP($I) $sPort($I) "" "" NOPROWIN
         }
      }
      set pList $oList
      incr I
   }
     
   return 1
}
