# THIS procedure promotes a requested VIDF/ file. It works only with 
#   archivers which promote data using the UDF protocol. 
#
#   NOTE: This procedure will overwrite existing data!
#
# INPUTS:
#   pList  - the promote list
#   iP     - the Server IP
#   Port   - the port the server listens on
#
# OUTPUTS:
#   pFiles - the files promoted
#   pComp  - the promoted files compression status

package provide Client 1.0

proc CLudfvPromote { pList iP Port pFiles pComp sTmO } {
   global PromoteList env UDFPaths tcl_platform

   upvar $pFiles dBGen
   upvar $pComp  fComp

   set dBGen ""
   set fComp ""
   lappend pList $Port
   if { [CLudfReqSend $pList $iP $Port $sTmO] == 0 } { 
      set PiD [ProPopUps $pList $iP $Port "" "" DOWN]
      return
   }

# FORM the VIDF directory which is on the same level as the PIDF directory.

   set dIr [file split $UDFPaths(0)]
   set dLen [expr [llength $dIr] - 1]
   set vDir [file join [lindex $dIr 0]]
   for { set I 1 } { $I < $dLen } { incr I } { 
      set vDir [file join $vDir [lindex $dIr $I]] 
   }
   set vDir [file join $vDir VIDFS]

# LOOP over the promote list.  This is the list of promotable files returned 
#   from the  server  A single entry in the promote list indicates a no data
#   condition.  In fact there are three entries per permotable file, the file
#   base name, its directory, and its compression status.

   set pLen [expr int ([llength $PromoteList] / 3) ]
   set fComp ""
   set dBGen ""
   for {set J 0 ; set I 0 } { $J < $pLen } { incr J ; incr I 3 } {
      set bName [lindex $PromoteList $I]
      set K [expr $I + 1]
      set fDir [lindex $PromoteList $K]
      set K [expr $I + 2]
      set cCode [lindex $PromoteList $K]

      set vName [file join $vDir ${bName}V ]
      set iName [file join $UDFPaths(2) ${bName}I ]

# IF the data already exists on the local on the system delete it and its
#   database entry.  There is a database entry only if the I file exists.

      if [file exists $vName] { file delete -force $vName }

      if [file exists $iName] {
         file delete -force $iName 
         set dbF [file join $UDFPaths(1) [lindex $pList 4].I.DBF]
         set nxF [file join $UDFPaths(1) [lindex $pList 4].I.NDX]
         set Pos [DBfileDup $dbF dB $bName]
         set dLen [llength $Pos]
         for { set L 0 } { $L < $dLen } { incr L } {
            set dBKey [list [lindex $dB(KeyList) [lindex [lindex $Pos $L] 1]]]
            DBdbfDelete $dbF [lindex [lindex $Pos $L] 0]
            DBndxDelete $nxF $dBKey 
         }
      }

# SET the request names for the files.  If we are promoting compressed 
#   data nuke any stale compressed version which may be lying around

      set vFile ${bName}V 
      set iFile ${bName}I 
      if { $cCode == 1 } { 
         append vFile ".gz" 
         if [file exist $vFile] { file delete -force $vFile }
      }

# PUT up the pop up which indicates that the promote is on

      if { [lindex $pList 12] >= 2 } { 
         set PiD [ProPopUps $pList $iP $Port $vFile "" PROWIN]
      }

# NOW request the data

      set Promote [list VIDF $fDir $vFile]
      CLreqUDF $Promote $iP $Port

# DID we get the data?  IF so log it.

      if [file exists $vFile] { 
         if { [file size $vFile] > 0 } {
            lappend fComp $cCode
            lappend dBGen $bName
         }
      }

# GET rid of the promote popup

      if { [lindex $pList 12] >= 2 } { 
         if [string match window* $tcl_platform(platform)] {
	   if { $PiD >= 0 } { catch { exec [auto_execok taskkill] /PID $PiD } }
         } else { catch {exec kill $PiD} }
      }
   }
}
