# THIS procedure promotes a requested header/data file pair. It works only 
#   with archivers which promote data using the UDF protocol.  There is a 
#   check made which prevents data already on the system from being promoted,
#   that is you can not overwrite existing data!
#
# INPUTS:
#   pList  - the promote list
#   iP     - the Server IP
#   Port   - the port the server listens on
#
# OUTPUTS:
#   pFiles - the files promoted
#   pComp  - the promoted files compression status

package provide Client 1.0

proc CLudfhdPromote { pList iP Port pFiles pComp sTmO } {
   global PromoteList env UDFPaths tcl_platform

   upvar $pFiles dBGen
   upvar $pComp  fComp

   set dBGen ""
   set fComp ""

   lappend pList $Port

   if { [CLudfReqSend $pList $iP $Port $sTmO] == 0 } { 
      set PiD [ProPopUps $pList $iP $Port "" "" DOWN]
      return
   }

# LOOP over the promote list.  This is the list of promotable files returned 
#   from the  server  A single entry in the promote list indicates a no data
#   condition.  In fact there are three entries per permotable file, the file
#   base name, its directory, and its compression status.

   set pLen [expr int ([llength $PromoteList] / 3)]
   for {set J 0 ; set I 0 } { $J < $pLen } { incr J ; incr I 3 } {
      set bName [lindex $PromoteList $I]
      set K [expr $I + 1]
      set fDir [lindex $PromoteList $K]
      set K [expr $I + 2]
      set cCode [lindex $PromoteList $K]

      set dName [file join $UDFPaths(2) ${bName}D ]
      set hName [file join $UDFPaths(2) ${bName}H ]

# DO NOT promote if the data files exist on the local system.  This has
#   caused problems.  Sometimes the file is there but its not in the data
#   base.  If you ignore the file and always promote sometimes when the
#   local and remote databases to not have the same endtimes to a file and
#   end up repromoting data you already have (not bad  but a waste of time).
#   So now if the data exists make sure its listed in the database.  If it
#   is then no promote!

      if { [file exists $hName] && [file exists $dName] } { 
         set dBF [file join $UDFPaths(1) [lindex $pList 4].HD.DBF]
         set PoS [DBfileDup $dBF dB $bName]
         if { [llength $PoS] > 0 } { lappend dBGen GOTIT ; continue } 
      }

# SET the request names for the files.  If we are promoting compressed 
#   data nuke any stale compressed version which may be lying around

      set dFile ${bName}D 
      set hFile ${bName}H 
      if { $cCode == 1 } { 
         append dFile ".gz" 
         append hFile ".gz" 
         if [file exist $dFile] { file delete -force $dFile }
         if [file exist $hFile] { file delete -force $hFile }
      }

# PUT up the pop up which indicates that the promote is on

      if { [lindex $pList 12] >= 2 } { 
         set PiD [ProPopUps $pList $iP $Port $hFile $dFile PROWIN]
      }

# NOW request the data

      set Promote [list UDF $fDir $dFile]
      CLreqUDF $Promote $iP $Port
      set Promote [list UDF $fDir $hFile ]
      CLreqUDF $Promote $iP $Port

# DID we get the data?  IF so log it.

      if { [file exists $dFile]  && [file exists $hFile] } { 
         set hSize [file size $hFile]
         set dSize [file size $dFile]
         if { $hSize > 0 && $dSize > 0 } {
            lappend fComp $cCode
            lappend dBGen $bName
         } else {
	    if [file exists $dFile] { file delete -force $dFile }
            if [file exists $hFile] { file delete -force $hFile }
         }
      }

# GET rid of the promote popup

      if { [lindex $pList 12] >= 2 } { 
         if [string match window* $tcl_platform(platform)] {
	   if { $PiD >= 0 } { catch { exec [auto_execok taskkill] /PID $PiD } }
         } else { catch {exec kill $PiD} }
      }
   }
}
