# THIS procedure sends a request to the Server asking for an IDFS H/D file.
#
# Inputs to this routine are:
#
#    Promote : The promote request which depends on what is being asked for
#    sUrL    : The Server URL 
#    sPort   : The Server port number

package provide Client 1.0

proc CLreqIDFS { pInfo sUrL sPort} {
   global DataRecv DonE 

   set Status 0

   set pOps [lindex $pInfo 0]
   set fName [lindex $pInfo 1]

# OPEN up the file to be transferred

   if [catch {open $fName w} fd ] {
      puts stderr "CLreqIDFS:  CANNOT OPEN FILE $fName"
      return NOFILE
   }

# CONFIGURE the file to binary

   fconfigure $fd -translation binary

# REQUEST the File

   set urL http://
   append urL $sUrL
   append urL /FileGet.cgi


   if { [catch { upvar #0 [http::geturl ${urL}?$pOps -channel $fd] rV }] == 1 } { 
      set rV(status) error
   } else { close $fd }

# PUT the returned promotable files into a list

   switch -exact -- $rV(status) {
      ok { set Status 1 }
      error { set Status 0 }
      reset { set Status 0 }
      timeout { set Status 0 }
   }

   unset rV

   return $Status
}
