package provide Client 1.0                                                 

# CREATE the needed part of a UDF data directory tree

proc CLmakeDTree { P  M  E  I { Path 1 } } {
   global env AllPMEIV

   upvar $Path dP
   
# IF Path has been set derive the directory names from that

   if { [array exists dP] > 0 } {
      set diR [file split $dP(2)]
      set dLen [llength $diR]
      set BeG [expr $dLen - 4]
      set P [lindex $diR $BeG] ; incr BeG
      set M [lindex $diR $BeG] ; incr BeG
      set E [lindex $diR $BeG] ; incr BeG
      set I [lindex $diR $BeG]
   }

# MAKE sure that there is a Project and Mission passed in

   if { [string length $P] == 0 } { return }
   if { [string length $M] == 0 } { return }

   set bD [file nativename $env(UDF_DATA)]
   if ![file isdirectory $bD] {
      puts stderr "Creating base UDF data directory $bD"
      file mkdir $bD
      puts stderr "Creating base UDF data PKGS directory" 
      file mkdir [file join $bD PKGS]
   }

   set bD [file join $bD $P]
   if ![file isdirectory $bD] {
      puts stderr "Creating UDF Project directory $bD"
      file mkdir $bD
   } 

   set bD [file join $bD $M]
   if ![file isdirectory $bD] {
      puts stderr "Creating UDF Mission directory $bD"
      file mkdir $bD
      puts stderr "Creating UDF Mission $M Database directory"
      file mkdir [file join $bD Database]
      puts stderr "Creating UDF Mission $M VIDFS directory"
      file mkdir [file join $bD VIDFS]
      puts stderr "Creating UDF Mission $M PIDFS directory"
      file mkdir [file join $bD PIDFS]
   } 

   set bD [file join $bD $E]
   if ![file isdirectory $bD] {
      puts stderr "Creating UDF EXPERIMENT directory $bD"
      file mkdir $bD
   } 

   set bD [file join $bD $I]
   if ![file isdirectory $bD] {
      puts stderr "Creating UDF INSTRUMENT directory $bD"
      file mkdir $bD
   } 
}
