# THIS procedure promotes a requested VIDF file. It works only with 
#   archivers which promote data using the IDFS protocol. 
#
#   NOTE: This procedure will overwrite existing data!
#
# INPUTS:
#   pList  - the promote list
#   iP     - the Server IP
#   Port   - the port the server listens on
#
# OUTPUTS:
#   pFiles - the files promoted
#   pComp  - the promoted files compression status

package provide Client 1.0

proc CLidfsvPromote { pList iP Port pFiles pComp } {
   global PromoteList env UDFPaths tcl_platform

   upvar $pFiles dBGen
   upvar $pComp  fComp

   set dBGen ""
   set fComp ""
   lappend pList $Port
   if { [CLidfsReqSend $pList $iP $Port] == 0 } { return }

# FORM the VIDF directory which is on the same level as the PIDF directory.

   set dIr [file split $UDFPaths(0)]
   set dLen [expr [llength $dIr] - 1]
   set vDir [file join [lindex $dIr 0]]
   for { set I 1 } { $I < $dLen } { incr I } { 
      set vDir [file join $vDir [lindex $dIr $I]] 
   }
   set vDir [file join $vDir VIDFS]

# LOOP over the promote list.  This is the list of promotable files returned
#   from the server.  The IDFS promote list is essentially a line from the
#   server database.  We need to break that apart to do our checks and then
#   to get the useful parts to form the data requests.  The list element is
#   a |  separated set of fields.
                                                                                
   set rList $PromoteList
   set PromoteList ""
   set rLen [llength $rList]
   set fComp ""
   set dBGen ""

   for { set I 0 } { $I < $rLen } { incr I } {
                                                                                
# SPLIT apart the fields
                                                                                
      set rE [split [lindex  $rList $I] "|"]
      if { [llength $rE] != 15 } { continue }
                                                                                
# DON'T want HD data
                                                                                
      if { [lindex $rE 0] == "H" } { continue }
                                                                                
# FORM the base file name
                                                                                
      set Tm [lindex $rE 5]
      set Hr [expr int( $Tm / 3600000)]
      set Mn [expr int(($Tm % 3600000) / 60000 )]
      set bName [format "%s%4d%03d%02d%02d" [lindex $rE 2] \
                            [lindex $rE 3] [lindex $rE 4] $Hr $Mn]
                                                                                
# THIS is the compression code
                                                                                
      set cCode [lindex $rE 11]

      set vName [file join $vDir ${bName}V ]
      set iName [file join $UDFPaths(2) ${bName}I ]

# IF the data already exists on the local on the system delete it and its
#   database entry.  There is a database entry only if the I file exists.

      if [file exists $vName] { file delete -force $vName }

      if [file exists $iName] {
         file delete -force $iName 
         set dbF [file join $UDFPaths(1) [lindex $pList 4].I.DBF]
         set nxF [file join $UDFPaths(1) [lindex $pList 4].I.NDX]
         set Pos [DBfileDup $dbF dB $bName]
         set dLen [llength $Pos]
         for { set J 0 } { $J < $dLen } { incr J } {
            set dBKey [list [lindex $dB(KeyList) [lindex [lindex $Pos $J] 1]]]
            DBdbfDelete $dbF [lindex [lindex $Pos $J] 0]
            DBndxDelete $nxF $dBKey 
         }
      }

# SET the request names for the files.  If we are promoting compressed 
#   data nuke any stale compressed version which may be lying around

      set vFile ${bName}V 
      set iFile ${bName}I 
      if { $cCode > 0 } { 
         append vFile ".gz" 
         if [file exist $vFile] { file delete -force $vFile }
      }

# PUT up the pop up which indicates that the promote is on

      if { [lindex $pList 12] >= 2 } { 
         set PiD [ProPopUps $pList $iP $Port $vFile "" PROWIN]
      }

# NOW request the data
                                                                                
      set Ops ""
      for { set K 1 } { $K <= 5 } { incr K } { append Ops [lindex $pList $K]+ }
      append Ops [lindex $rE 3]+[lindex $rE 4]+[lindex $rE 5]+
      append Ops 0+${cCode}+xxx
                                                                                
      set Promote [list V+$Ops $vFile]

      if { [CLreqIDFS $Promote $iP $Port] == 1 } {

# DID we get the data?  IF so log it.

         if [file exists $vFile] { 
            if { [file size $vFile] > 0 } {
               if { $cCode > 0 } { set cCode 1 }
               lappend fComp $cCode
               lappend dBGen $bName
            }
         }
      }
# GET rid of the promote popup

      if { [lindex $pList 12] >= 2 } { 
         if [string match window* $tcl_platform(platform)] {
	   if { $PiD >= 0 } { catch { exec [auto_execok taskkill] /PID $PiD } }
         } else { catch {exec kill $PiD} }
      }
   }
}
