# THIS procedure promotes a requested PIDF file. It works only with 
#   archivers which promote data using the IDFS protocol. 
#
#   NOTE: This procedure will overwrite existing data!  It also promotes on
#         faith.  There is no request to see if the data is really there or
#         not.  Since we can't ask if the file is there we make sure that
#         what we get back is gzipped.
#
# INPUTS:
#   pList  - the promote list
#   iP     - the Server IP
#   Port   - the port the server listens on
#
# OUTPUTS:
#   pFiles - the files promoted
#   pComp  - the promoted files compression status

package provide Client 1.0

proc CLidfspPromote { pList iP Port } {
   global PromoteList env UDFPaths tcl_platform

# SET up the promote window if the user wants to see it.

   set pFile [lindex $pList 5].pidf.v2.gz
   if { [lindex $pList 12] >= 2 } { 
      set PiD [ProPopUps $pList $iP $Port $pFile "" PROWIN]
   }

# PROMOTE the data

   set Ops ""
   for { set I 1 } { $I <= 5 } { incr I } { append Ops [lindex $pList $I]+ }
   append Ops 1990+1+0+0+2+xxx
                                                                                
   set Promote [list P+$Ops $pFile]
   if { [CLreqIDFS $Promote $iP $Port] == 1 } {

# SEE if we got the data and that its a gzipped file

      set rV [CLfileCheck $pFile]
   } else { set rV -1 }

# GET rid of the promote popup

   if { [lindex $pList 12] >= 2 } { 
      if [string match window* $tcl_platform(platform)] {
         if { $PiD >= 0 } { catch { exec [auto_execok taskkill] /PID $PiD } }
      } else { catch {exec kill $PiD} }
   }

   return $rV
}
