# OUTPUTS log statistics. 

package provide ArTool 1.0

proc ATstatsOut { Stats  } {
   global asANS

   switch -exact -- $Stats {
      IP {
         upvar 0 asANS(Stats) InFo
         set W  .giSL.iinfo
         set sV $asANS(iSort)
         set FmT [list "%-15s     " "%5d    " "%5d    " "%5d  " "%9d"]
	 set GetS [list 0 2 3 1 4]
	 set Test -1
      }
      PACKAGE {
         upvar 0 asANS(PkGs) InFo
         set W  .giSL.pinfo
         set sV $asANS(pSort)
	 set FmT [list "%-30s   " "%3d"]
	 set GetS [list 0 1]
	 set Test -1
      }
      REQUEST {
         upvar 0 asANS(ReQs) InFo
         set W  .giSL.rinfo
         set sV $asANS(rSort)
         set FmT [list "%-10s      " "%5d"]
	 set GetS [list 0 1]
	 set Test 1
      }
   }

   if {$sV == 0 } {
      set InFo [lsort -increasing -ascii -index $sV $InFo]
   } else {
      set InFo [lsort -decreasing -integer -index $sV $InFo]
   }

   set nE [llength $InFo] 
   set nT [llength $GetS]
   for { set I 0 } { $I < $nE } { incr I } {
      set V [lindex $InFo $I]
      if { $Test >= 0 } {
         set tV [lindex $V $Test] 
	 if { $tV > 0 } { set Show 1 } else { set Show 0 }
      } else { set Show 1 } 

      if $Show {
         set OuT ""
         for { set J 0 } { $J < $nT } { incr J } {
            append OuT [format [lindex $FmT $J] [lindex $V [lindex $GetS $J]]] 
         }
         $W.c2r0 insert end $OuT
      }
   }
}
