# PUTS up the hack statistics. 

package provide ArTool 1.0

proc ATstatsHack {  } {
   global asANS

   set W  .giSL.hinfo

   if ![winfo exists $W] {
      set P 1
      set nW .gSL.[lindex $asANS(wOrder) $P]
      while { ![winfo exists $nW] && ($P >= 0) } {
         incr P -1
      }
      set Wa [lindex $asANS(wOrder) $P]
      GUIFrame $W -1 pack|top||both||||||||$Wa
   }

   if [winfo exists $W.c0r0] { return }

   set HacKs ""
   set sLen [llength $asANS(Stats)] 
   for { set I 0 } { $I < $sLen } { incr I } {
      set InFo [lindex $asANS(Stats) $I]
      if {[lindex $InFo 1] > 0 } { lappend HacKs $InFo }
   }

   set LaB "IP ADDRESS          HACKS   INQUERIES     SENDS"
   set hLen [llength $HacKs] 
   if { $hLen > 0 } {
      GUILabel $W.c0r0 "HACK STATISTICS" c grid|0|0|ew 5 0 #ff0000
      $W.c0r0 configure -font [list fixed 12 bold]
      GUIbuttonPush $W.c0r1 PRINT grid|0|1|e "ATprntLog $W.c2r0 HACKS {$LaB}"
      GUILabel $W.c1r0 $LaB c grid|1|0|w||2
      $W.c1r0 configure -font [list fixed 10]
      GUIboxList $W.c2r0 55 6 grid|2|0|w||2 "" multiple 0 1
      $W.c2r0 configure -font [list fixed 10]

      set FmT "%-15s     %5d       %5d     %5d"
      if {$asANS(hSort) == 0 } {
         set HacKs [lsort -increasing -ascii -index 0 $HacKs]
      } else { set HacKs [lsort -decreasing -integer -index 1 $HacKs] }

      for { set I 0 } { $I < $hLen } { incr I } {
         set hK [lindex $HacKs $I]
         set iP  [lindex $hK 0]
         set nH [lindex $hK 1]
         set nI [lindex $hK 2]
         set nS [lindex $hK 3]
         $W.c2r0 insert end [format $FmT $iP $nH $nI $nS]
      }
   } 
}
