package provide ArTool 1.0

proc ATsoftwareView { } {
   global arANS sDefs

   ATvarInit VIEWER

   set W   .swView

   set Sz  [list 9 11 9 5 0]
   set LaB [list CATAGORY PACKAGE REVISION ACODE "ENTRY DATE"]
   set sBy  [list ascii ascii ascii ascii integer]

   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "SOFTWARE CONTENTS"

      set Wa  $W.top
      set Wb  $W.act
      set Wc  $W.src
      set Wd  $W.list

      GUIFrame $Wa -1 pack|top||both|true
      GUIFrame $Wb -1 pack|top||both|true
      GUIFrame $Wc -1 pack|top|w
      GUIFrame $Wd -1 pack|top||both|true

      GUILabel $Wa.lab "SOFTWARE ARCHIVE CONTENTS" c \
         pack|left|center|x|true 6 30 "" [list times 16 bold]
      GUIbuttonPush $Wa.quit QUIT pack|right "destroy $W"  6

      GUILabel $Wb.lab "ACTIONS" w pack|left 0 9
      GUIbuttonPush $Wb.query QUERY\nDATABASE pack|left \
           "ATswQuery $Wd.list" 0 11
      $Wb.query configure -font [list fixed 10]
      GUIbuttonPush $Wb.del DELETE\nENTRY pack|left \
           "ATswDelete $Wd.list" 0 11
      $Wb.del configure -font [list fixed 10]
      GUIbuttonPush $Wb.clr CLEAR pack|right "$Wd.list delete 0 end" 0 7
      $Wb.clr configure -font [list fixed 10]

      GUILabel $Wc.lab "SOURCE" w grid|0|0 0 9 
      set pLen [llength $arANS(PKGS)]
      set EnD [expr int($pLen / 2) + $pLen % 2]
      set I 0
      for { set CoL 1 } { $CoL <= $EnD } { incr I ; incr CoL } {
         set pN [lindex $arANS(PKGS) $I]
         set arANS(db,$pN) 0
         GUIbuttonCheck $Wc.cb$I $pN grid|0|$CoL arANS(db,$pN) "" 0 11
      }
      set EnD [expr int($pLen / 2)]
      for { set CoL 1 } { $CoL <= $EnD } { incr I ; incr CoL } {
         set pN [lindex $arANS(PKGS) $I]
         set arANS(db,$pN) 0
         GUIbuttonCheck $Wc.cb$I $pN grid|1|$CoL arANS(db,$pN) "" 0 11
      }

      GUIblankRow $Wd 0 1.5
      set nLab [llength $Sz]
      for { set J 0 } { $J < $nLab } { incr J } {
         set lW $Wd.l2,$J
         set srt [lindex $sBy $J]
         GUIbuttonPush $lW [lindex $LaB $J] grid|1|$J \
             "ATcolumnSort $Wd.list SW $J increasing $srt" 0 [lindex $Sz $J]
         $lW configure -font [list fixed 10]
      }

      GUIboxList $Wd.list  52 20 grid|2|0|||8 "" multiple 0 1
      $Wd.list configure -font [list fixed 10]
   }
}
