package provide ArTool 1.0

proc ATserverGUI { } {
   global asANS env logW


# OPEN the server configure file and read the contents.  IF there is no
#   file present then initialize the options and create the configure
#   file.

   ATvarInit SERVER
   set sCFile [file join $env(UDF_HOME) Archives ServerConfig]
   if [file exists $sCFile] {
      if [catch {open $sCFile r } fd] {
         $logW insert end "CAN'T ACCESS File $sCFile\n"
      } else {
         while { [gets $fd LiNe] > 0 } {
            set Flds [split $LiNe "|"]
            set asANS([lindex $Flds 0]) [lindex $Flds 1]
            set asANS(_[lindex $Flds 0]) [lindex $Flds 1]
         }
         close $fd
      }
   } 

# OPEN the GUI
 
   set W .aServer
   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "SERVER CONFIGURATION MENU"

      set Wa  $W.top
      set WaR $Wa.right
      set WaL $Wa.left
      set Wb  $W.mid
      set Wc  $W.bot

      GUIFrame $Wa -1 pack|top||x|true
      GUIFrame $Wb -1 pack|top||x|true
      GUIFrame $Wc -1 pack|top||x|true 
      GUIFrame $WaL 0 pack|left|w|x|true -1 10
      GUIFrame $WaR 0 pack|right|e|x -1 10

      GUILabel $WaL.lab "SERVER CONFIGURATION" c pack|left|center|x|true \
         6 30 "" [list times 16 bold]
      GUIbuttonPush $WaR.quit QUIT pack|right|e "destroy $W" 6 0 groove

      set ynOP [list YES|1 NO|0]
      set oOP  [list CREATE|w APPEND|a]

      set R 0
      GUILabel $Wb.llog "LOG REQUESTS" w grid|$R|0|w 6 -1 Black
      GUIbuttonToggle $Wb.log $asANS(log) grid|$R|1|w||9 $ynOP  \
           "GUIoptsToggle .aServer.mid.log asANS(log) PRI " 6
      incr R
      if [string match "w" $asANS(oMode)] { 
         set oLab CREATE 
      } else { set oLab APPEND } 
      GUILabel $Wb.lomode "OPEN MODE" w grid|$R|0|w 6 -1 Black
      GUIbuttonToggle $Wb.omode $oLab grid|$R|1|w||9 $oOP  \
           "GUIoptsToggle .aServer.mid.omode asANS(oMode) ALT " 6
      incr R
      GUILabel $Wb.llogf "LOG FILE" w grid|$R|0|w 6 -1 Black
      GUIboxEntry $Wb.slogf grid|$R|1|w||8 40 asANS(logFile)

      incr R
      GUIblankRow $Wb $R 2
      incr R

      incr R 
      GUILabel $Wb.elog "LOG ERRORS" w grid|$R|0|w 6 -1 Black
      GUIbuttonToggle $Wb.err $asANS(error) grid|$R|1|w||9 $ynOP  \
           "GUIoptsToggle .aServer.mid.err asANS(error) PRI " 6
      incr R
      if [string match "w" $asANS(errMode)] { 
         set oLab CREATE 
      } else { set oLab APPEND } 
      GUILabel $Wb.lemode "OPEN MODE" w grid|$R|0|w 6 -1 Black
      GUIbuttonToggle $Wb.emode $oLab grid|$R|1|w||9 $oOP  \
           "GUIoptsToggle .aServer.mid.emode asANS(errMode) ALT " 6
      incr R
      GUILabel $Wb.elogf "LOG FILE" w grid|$R|0|w 6 -1 Black
      GUIboxEntry $Wb.selogf grid|$R|1|w||8 40 asANS(errFile)

      incr R
      GUIblankRow $Wb $R 1
      incr R
      GUIbuttonPush $Wc.doit "UPDATE" pack|left ATserverChg  6 0 groove
      GUIbuttonPush $Wc.reset "RESET" pack|left "ATmenuReset SERVER" \
            6 0 groove
      GUIbuttonPush $Wc.log "VIEW LOG" pack|left "ATlogGUI" \
            6 0 groove
      GUIbuttonPush $Wc.beg "START SERVER" pack|right "" \
            6 0 groove

      set newText [lindex [GUinverseOpts $Wb.log $asANS(log)] 0]
      $Wb.log configure -text $newText
      set newText [lindex [GUinverseOpts $Wb.omode $asANS(oMode)] 0]
      $Wb.omode configure -text $newText
   } else { GUIwindowCtrl $W }
}
