package provide ArTool 1.0

proc ATreadInfo { FiLe } {
   global env logW arANS

# INITIALIZE the base window name according to the file being parsed

   if [string match ArchiveInfo $FiLe] { 
      set Name "ARCHIVE CODES (ArchiveInfo)"
      set W .sWin
      set LFmt "%-14s %s"
      set Hdr1 [format $LFmt "Archive Code" "Data Location"]
      set Hdr2 [format $LFmt "------------" "-------------"]
      set GuI ATacodeGUI
   } else { 
      set W .aWin
      set Name "ARCHIVES (ServerInfo)"
      set LFmt "%-25s %-8s %s"
      set Hdr1 [format $LFmt "Archive ID" " Port " "Archive Directory"]
      set Hdr2 [format $LFmt "----------" "------" "-----------------"]
      set GuI ATarchiveGUI
   }

# INITIALIZE NoFile flag to indicate that the file we are after is not on the
#   the system

   set NoFile 1

# WE are either getting data from the ArchiveInfo file or from the ServerInfo
#   file.  The two files should be located in the directory UDF_HOME/Archives.  
#   They have their own directory since installs tend to remove a directory
#   in the install process and we don't want to loose this info.

   if [info exists env(UDF_HOME)] {
      set aDir [file join $env(UDF_HOME) Archives]
      set fName [file join $aDir $FiLe]
      if [file exists $fName] { set NoFile 0 }
   } else {
      lappend Msg "ENVIRONMENT variable UDF_HOME does not exist"
      lappend Msg "MUST be set prior to archive manipulation"
      GUImsgPopUp .ewin -1 -1 $Msg
      return -1
   } 

# IF we didn't find a file present that's what we output

   set sInfo ""
   if $NoFile {
      lappend sInfo $Hdr1
      lappend sInfo $Hdr2
   } else {
      if [catch {open $fName r} fd] {
         $logW insert end "UNABLE TO OPEN $fName\n"
         retrun
      }

      while { [gets $fd LiNe] >= 0 } { lappend sInfo $LiNe }
   }

   set sLen [llength $sInfo]
   set X 70
   set Y [expr $sLen + 3]
   if { $Y > 12 } { set Y 12 }

# GET rid of the window if it exists

   if [winfo exists $W] { destroy $W }

# SET up the pop up

   toplevel $W
   set Wt $W.top
   set Wm $W.mid
   set Wb $W.bot
   GUIFrame $Wt -1 pack|top||x
   GUIFrame $Wm -1 pack|top||x
   GUIFrame $Wb -1 pack|top||x
                                                                                
   GUILabel $Wt.lab $Name c pack|left 6 -1 #0000ff [list times 16 bold] 
   GUIbuttonPush $Wt.done DONE pack|right "destroy $W" 10 8 groove
   GUIbuttonPush $Wb.new NEW pack|left| $GuI 6 10 groove
   if [string match .aWin $W] { 
      GUIbuttonPush $Wb.edit CONFIGURE pack|left \
                          "ATconfigGUI $Wm.log" 6 10 groove
      GUIbuttonPush $Wb.upa  "UPDATE ALL" pack|right \
                          "ATarchiveUpdate $Wm.log ALL" 6 10 groove
      GUIbuttonPush $Wb.up   UPDATE pack|left \
                          "ATarchiveUpdate $Wm.log ONE" 6 10 groove
      GUIbuttonPush $Wb.vw   VIEW pack|left \
                          "ATarchiveView $Wm.log" 6 10 groove
   }
   GUIbuttonPush $Wb.del  DELETE pack|left \
                          "ATdeleteEntry $Wm.log $fName" 6 10 groove

   GUIboxList $Wm.log $X $Y pack|top||x|true ""

   $Wm.log configure -font [list fixed 10] 
   for { set I 0 } { $I < $sLen } { incr I } {
      $Wm.log insert end [lindex $sInfo $I]
   }
}
