package provide ArTool 1.0

proc ATplotStat { Plot } {
   global asANS GphInfo WinInfo

   switch -exact -- $Plot {
      CONNECTS { set pN 1 ; set doPlot $asANS(cPlot) }
      REQUESTS { set pN 2 ; set doPlot $asANS(rPlot) }
      PACKAGES { set pN 3 ; set doPlot $asANS(pPlot) }
      BYTES    { set pN 4 ; set doPlot $asANS(bPlot) }
      HACKS    { set pN 5 ; set doPlot $asANS(hPlot) }
   }

   set W .pWin$pN

   if !$doPlot { 
      if [winfo exists $W] { destroy $W }  
      return 
   }

   ATassemPlot $Plot G gI

   if ![winfo exists $W] {
      toplevel $W
 
      GUIFrame $W.p$pN -1 pack|top||both
      GUICanvas $W.p$pN 600 600 600 600
   }

   if !$asANS(GphOn) {
      GraphicsOn TK ETones SWAP NONE OMIT
      set asANS(GphOn) 1
   }

   SetScreen $pN $W.p$pN
   GenWindow fW 0.0 0.0 0.0 1.0 1.0 0.0  0. 0. 0. 1. 1. 0.
   GenWindow $pN 0.20 0.05 0.0 0.95 0.80 0.0  0. 0. 0. $gI(1) 1. 0.
   PlotColor HOLD $GphInfo(Black) $GphInfo(Black)
   Box fW $WinInfo($pN,pp0) $WinInfo($pN,pp1) 0.0 \
                  $WinInfo($pN,pp3) $WinInfo($pN,pp4) 0.0
   PlotColor HOLD $GphInfo(White) -1
   DefinePlot $pN $pN
   TextProp 10

   AutoScale $pN Yb G $gI(4) [list 0.0 1.0e30 0.0 OFF 0.0 OFF -1.0 OFF 0]
#  AutoScale $pN Yt G $gI(4) [list 0.0 1.0e30 0.0 OFF 0.0 OFF -1.0 OFF 0]

   TUgridInfo 30 gI X
   PlotColor HOLD $GphInfo(Blue) $GphInfo(Blue)
   for { set I 0 ; set J 1 } { $I < $gI(4) } { incr I ; incr J } {
       Box $pN $X($I) 0.0 0.0 $X($J) $G($I) 0.0
   }

   PLTinfoChg $pN Yb NUMBERS NFORMAT %.2e

   PLTinfoChg $pN Xt NUMBERS NSIZE 12
   PLTinfoChg $pN Y NUMBERS TSIZE 12
   PLTinfoChg $pN Y TICKS MJNUMBER 5
   PLTinfoChg $pN Y TICKS MNNUMBER 5

   set LaBs [list "" 1.0 "" 1.0 $asANS(Time) 4.0]
   set NuMs [list NONE BOT NONE BOTH]
   PLTaxisRec $pN Xt NONE AXIS 7.0 CENTER center $Plot
   PlotOutlines $pN $LaBs $NuMs

   PLTinfoChg $pN Xt NUMBERS TSIZE 10

   scan $asANS(EndT) "%4d%3d%5d" eY eD eS
   scan $asANS(BegT) "%4d%3d%5d" bY bD bS
   set YDM [TUdateConv YD.S $bY $bD]
   set cYr [lindex $YDM 0]
   set cDiY [TUyearLeap $cYr]
   set cMo [lindex $YDM 2]
   set Mo [list "$cMo 0"]
   for { set I 1 } { $I < $gI(4) } { incr I } {
      set DoY [expr $bD + $I]
      if { $DoY > $cDiY } {
         set DoY 1
	 incr cYr
         set cDiY [TUyearLeap $cYr]
      }
      set YDM [lindex [TUdateConv YD.S $cYr $DoY] 2]
      if ![string match $YDM $cMo] {
         lappend Mo [list $YDM $I]
         set cMo $YDM 
      }
   }

   WinClip $pN 0
   set nTics [llength $Mo]
   for { set I 1 } { $I < $nTics } { incr I } {
       set iFo [lindex $Mo $I] 
       set PoS [lindex $iFo 1] 
       PLTaxisRec $pN Xt ONEMAJOR NONE 0 $PoS
   }

   set cSO [GPHtextLen X X]
   lappend Mo [list "" $gI(4)]
   set nTics [llength $Mo]
   for { set I 0 ; set J 1 } { $J < $nTics } { incr I ; incr J } {
       set iFa [lindex $Mo $I] 
       set iFb [lindex $Mo $J] 
       set PoS [expr ([lindex $iFa 1] + [lindex $iFb 1])/2.0] 
       set nChar [expr int(([lindex $iFb 1] - [lindex $iFa 1]) / $cSO)] 
       set mO [lindex $iFa 0]
       set moL [expr [string length $mO] + 2]
       if { $nChar < $moL  } { 
           set mO [string range $mO 0 2]
           if { $nChar < 5 } { set mO [string index $mO 0] }
       }
       PLTaxisRec $pN Xt NONE AXIS 0.5 $PoS center $mO
   }
}
