# SETS up the grid information for the statistics plots as well as sets up
#   the offset list to use when converting Year/Day to Day from start date.

package provide ArTool 1.0

proc ATplotGrid { bY bD eY eD gInfo } {
   global asANS

   upvar $gInfo gI

# SETS up the number of days between the start and the stop dates

   if { $bY == $eY } {
      set dX [expr $eD - $bD + 1]
   } else {
      set tD [TUyearLeap $bY]
      set dX [expr $tD - $bD + 1]
      set Y [expr $bY + 1] 
      for {  } { $Y < $eY } { incr Y } {
         set dX [expr $dX + [TUyearLeap $Y]]
      }
      set dX [expr $dX + $eD]
   }

# SETS up the day offsets.  This is a day offset only if the year changes.

   set Off 0
   for { set I $bY } { $I < $eY } { incr I } {
      set Last [lindex $Off $I]
      lappend Off [expr $Last + [TUyearLeap $I]]
   }

   set gI(0) 0.0
   set gI(1) [expr double($dX)]
   set gI(2) -1.0
   set gI(3) 1.0
   set gI(4) $dX
   set gI(5) 1 
   set gI(6) POINT 
   set gI(7) POINT 
   set gI(8) COLUMN
   set gI(9) KEEP
   set gI(10) NEW:ADD:END
   set gI(11) 0.0
   set gI(12) -1.0
   set gI(13) 0.0
   set gI(14) 1.0e30
   set gI(15) NO
   set gI(16) NO

   return $Off
}
