# Process a log transaction

package provide ArTool 1.0

proc ATlogTrans { Trans } {
   global asANS

   set sTrans ""
   set Tm ""
   set Req ""
   set pS ""
   set ByTes 0

   set tL [expr [llength $Trans] - 1]
   set LiNe [lindex $Trans 0]

   set fCh [string index [string trim $LiNe] 0]
   if { $fCh == "S" } { 
      incr asANS(TotErrs)
   } elseif { $fCh == "H" } { 
      incr asANS(TotHacks)
   } else {
      set IP [lindex [split [lindex $LiNe 4] "/"] 0]
      set Yr [TUdataNoOctal [lindex $LiNe end]]
      set Dy [TUdataNoOctal [lindex $LiNe 9]]
      set Mo [lindex $LiNe 8]
      set TiMe [lindex $LiNe 10]
      set asANS(TimeB) "$Mo $Dy $Yr $TiMe"
      set YD [TUdateConv YDM $Yr $Dy $Mo]
      set HMS [split $TiMe ":"]
      set Hr [TUdataNoOctal [lindex $HMS 0]]
      set Mn [TUdataNoOctal [lindex $HMS 1]]
      set Sc [TUdataNoOctal [lindex $HMS 2]]
      set SoD [expr 3600 * $Hr + 60 * $Mn + $Sc] 
      set Tm [lindex $YD 0][format "%03d%05d" [lindex $YD 1] $SoD]
      if $asANS(First) { 
         set asANS(TimeA) "$Mo $Dy $Yr $TiMe"
         set asANS(BegT) $Tm
         set asANS(First) 0
      }

      incr asANS(TotTrans)

      for { set I 1 } { $I <= $tL } { incr I } {
         set LiNe [lindex $Trans $I]
         set fCh [string index [string trim $LiNe] 0]
         if { ($fCh == "(") && ([string first Sending $LiNe] >= 0) } {
            set P [string first error $LiNe]
	    if { $P >= 0 } {
               incr asANS(TotErrs)
	    } else {
               set IP [lindex [split [lindex $LiNe 4] "/"] 0]
               incr asANS(TotPkgs)
               set pS [lindex $LiNe 2] 
               set P  [lsearch $asANS(PkgBase) $pS]
               if { $P >= 0 } { 
                  set pInfo [lindex $asANS(PkGs) $P]
                  set pInfo [list $pS [expr [lindex $pInfo 1] + 1]]
                  set asANS(PkGs) [lreplace $asANS(PkGs) $P $P $pInfo]
               } else  { 
                  lappend asANS(PkGs) [list $pS 1] 
                  lappend asANS(PkgBase) $pS 
               }

               set P [string first bytes) $LiNe]
	       if { $P >= 0 } {
                  set lEa [expr [llength $LiNe] - 1]
                  set lEb [expr $lEa - 1]
                  if [string match bytes) [lindex $LiNe $lEa]] {
                     set bInfo [lindex $LiNe $lEb]
                     set ByTes [string trim [string range $bInfo 1 end]]
                     incr asANS(TotBytes) $ByTes
                  }
               } else {
                  set P [string first ( $LiNe 10]
	          lappend sTrans [string range $LiNe $P end]
	          if { $I < $tL } { 
	             incr I
	             set Rest [lindex $Trans $I]
                     if [string match bytes) [lindex $Rest 1]] {
                        set bInfo [lindex $Rest 0]
                        set ByTes [string trim [string range $bInfo 1 end]]
                        incr asANS(TotBytes) $ByTes
	             } else { lappend sTrans $Rest }
                  }
	          if { $I < $tL } { 
	             incr I
	             set Rest [lindex $Trans $I]
                     if [string match bytes) [lindex $Rest 1]] {
                        set bInfo [lindex $Rest 0]
                        set ByTes [string trim [string range $bInfo 1 end]]
                        incr asANS(TotBytes) $ByTes
	             }      
                  }
               }
	    }
         } else {
            set IP  [lindex $LiNe 0] 
            set Req [lindex $LiNe 3]
	    set P [lsearch $asANS(AllReq) $Req]
	    if [string match AREUUP $Req] { incr asANS(TotTrans) -1 }
	    if { $P < 0 } { 
	       set Req HACK
               incr asANS(TotHacks)
            } else { 
               set rInfo [lindex $asANS(ReQs) $P]
               set rInfo [list $Req [expr [lindex $rInfo 1] + 1]]
	       set asANS(ReQs) [lreplace $asANS(ReQs) $P $P $rInfo]
            }
         }
      }

      if { ([string length $IP] > 0) && ( $tL > 0 ) } {
        lappend asANS(IP) [list $IP $Tm $Req $pS $ByTes]
      }

      if { [llength $sTrans] > 0 } {
         ATlogTrans $sTrans
      }
   }

   set fCh [string index [string trim $asANS(LiNe)] 0]
   if { $fCh == "S" } { 
      incr asANS(TotErrs)
      set asANS(LiNe) ""
   } elseif { $fCh == "H" } { 
      incr asANS(TotHacks)
      set asANS(LiNe) ""
   }

   return $Tm
}
