# FRONT end GUI to the archive logfile analysis function

package provide ArTool 1.0

proc ATlogGUI {  } {
   global asANS

   ATvarInit LOGSTATS

   set OpsA [list Request Number]
   set OpsB [list IP Number]
   set OpsC [list Package Number]
   set OpsD [list IP Hacks Connects Sends Bytes ]

   set lFmt [list times 12 bold]

   set W   .giSL
   set Wa  $W.cmds
   set Wb  $W.opts
   set Wc  $W.ginfo
   set Wd  $W.plots

   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "Server Log Parser"

      GUIFrame $Wa -1 pack|top||both
      GUIFrame $Wb -1 pack|top||both
      GUIFrame $Wd -1 pack|top||both
      GUIFrame $Wc -1 pack|top||both

      GUIbuttonPush $Wa.quit QUIT pack|right "destroy .giSL"  6
      GUIbuttonPush $Wa.parse PARSE pack|left "ATparseLog"  6
      GUIbuttonPush $Wa.prnt PRINT pack|left "ATprntLog" 8

      GUILabel $Wb.r1c0 "VIEW" c grid|1|0|news 0 10 "" $lFmt
      GUILabel $Wb.r1c1 "SORT BY" c grid|1|1|news 0 15 "" $lFmt

      GUIbuttonCheck $Wb.r2c0 REQUESTS grid|2|0 asANS(rStat) \
                      "ATstatAction REQUESTS" 0 12
      GUIbuttonCheck $Wb.r3c0 PACKAGES grid|3|0 asANS(pStat) \
                      "ATstatAction PACKAGES" 0 12
      GUIbuttonCheck $Wb.r4c0 IPs grid|4|0 asANS(iStat) \
                      "ATstatAction IPS" 0 12

      GUIbuttonToggle $Wb.r2c1 Request grid|2|1 $OpsA \
                      "ATsortAction REQUEST" 0 10
      GUIbuttonToggle $Wb.r3c1 Package grid|3|1 $OpsC \
                      "ATsortAction PACKAGE" 0 10
      set LaB [lindex $OpsD $asANS(iSort)]
      GUIbuttonMenu $Wb.r4c1 $LaB grid|4|1 $OpsD  \
                      "ATsortAction IP " 10

      GUILabel $Wd.r0c0 "PLOTS" c grid|0|0|news 0 10 "" $lFmt
      GUIbuttonCheck $Wd.r0c1 CONNECTS grid|0|1 asANS(cPlot) \
                      "ATplotStat CONNECTS" 0 12
      GUIbuttonCheck $Wd.r0c2 REQUESTS grid|0|2 asANS(rPlot) \
                      "ATplotStat REQUESTS" 0 12
      GUIbuttonCheck $Wd.r0c3 PACKAGES grid|0|3 asANS(pPlot) \
                      "ATplotStat PACKAGES" 0 12
      GUIbuttonCheck $Wd.r1c1 BYTES grid|1|1 asANS(bPlot) \
                      "ATplotStat BYTES" 0 12
      GUIbuttonCheck $Wd.r1c2 HACKS grid|1|2 asANS(hPlot) \
                      "ATplotStat HACKS" 0 12

      set RoW 0
      GUIvLabel $Wc.r0c0 asANS(Time) c grid|$RoW|0|ew||6 0 0
      $Wc.r0c0 configure -font [list fixed 10 bold]
      incr RoW
      GUILabel  $Wc.r1c0 "BYTES SENT:" c grid|$RoW|0|e 5 0 #00fe00
      GUIvLabel $Wc.r1c1 asANS(TotBytes) w grid|$RoW|1|w 0 12
      $Wc.r1c1 configure -font [list fixed 10]
      GUILabel  $Wc.r1c2 "HACK ATTEMPTS:" c grid|$RoW|2|e 5 0 #00fe00
      GUIvLabel $Wc.r1c3 asANS(TotHacks) w grid|$RoW|3|w 0 12
      $Wc.r1c3 configure -font [list fixed 10]
      incr RoW
      GUILabel  $Wc.r2c0 "CONNECTIONS:" c grid|$RoW|0|e 5 0 #00fe00
      GUIvLabel $Wc.r2c1 asANS(TotTrans) w grid|$RoW|1|w 0 12
      $Wc.r2c1 configure -font [list fixed 10]
      GUILabel  $Wc.r2c2 "ERRORS:" c grid|$RoW|2|e 5 0 #00fe00
      GUIvLabel $Wc.r2c3 asANS(TotErrs) w grid|$RoW|3|w 0 12
      $Wc.r2c3 configure -font [list fixed 10]
      incr RoW
      GUILabel  $Wc.r3c0 "PKGS SENT:" c grid|$RoW|0|e 5 0 #00fe00
      GUIvLabel $Wc.r3c1 asANS(TotPkgs) w grid|$RoW|1|w 0 12
      $Wc.r3c1 configure -font [list fixed 10]
   }
}
