package provide ArTool 1.0

proc AThdvpQuery { W ViD } {
   global env arANS aCodeDir SySCmDs

   switch -exact -- $ViD {
      HD -
      V  {

         set Yr 1000 ; set Dy 1 ; set Hr 0 ; set Mn 0 ; set Sc 0
         if ![string match YEAR $arANS(yRb)] { set Yr $arANS(yRb) } 
         if ![string match DAY $arANS(dYb)]  { set Dy $arANS(dYb) }
         if ![string match HR $arANS(hRb)]   { set Hr $arANS(hRb) }
         if ![string match MIN $arANS(mNb)]  { set Mn $arANS(mNb) }
         if ![string match SEC $arANS(sCb)]  { set Sc $arANS(sCb) }
         set Ms [expr 3600000 * $Hr + 60000 * $Mn + 1000 * $Sc]
         set bT [format "%4d%03d%08d" $Yr $Dy $Ms] 
                                                                                
         set Yr 9000 ; set Dy 1 ; set Hr 0 ; set Mn 0 ; set Sc 0
         if ![string match YEAR $arANS(yRe)] { set Yr $arANS(yRe) } 
         if ![string match DAY $arANS(dYe)]  { set Dy $arANS(dYe) }
         if ![string match HR $arANS(hRe)]   { set Hr $arANS(hRe) }
         if ![string match MIN $arANS(mNe)]  { set Mn $arANS(mNe) }
         if ![string match SEC $arANS(sCe)]  { set Sc $arANS(sCe) }
         set Ms [expr 3600000 * $Hr + 60000 * $Mn + 1000 * $Sc]
         set eT [format "%4d%03d%08d" $Yr $Dy $Ms] 

         if [string match HD $ViD] {
            set FmT "%-21s%-19s%-20s%-6s%-10s %4d  %-s"
            set NeedSrc 1
            set U(P) $arANS(0,P) ; set U(M) arANS(0,M) 
            if { [string length $arANS(0,E)] == 0 } { 
               set U(E) "" 
            } else { set U(E) $arANS(0,E) }

            set pList [DBudfLineage]
            set pB [lsearch -exact $pList $arANS(0,P)]
            set pE [expr $pB + 1]
            set pList [DBudfLineage $arANS(0,P)]
            set mB [lsearch -exact $pList $arANS(0,M)]
            set mE [expr $mB + 1]
            set pList [DBudfLineage $arANS(0,P) $arANS(0,M)]
            if { [string length $arANS(0,E)] == 0 } { 
               set eB 0
               set eE [llength $pList]
            } else {
               set eB [lsearch -exact $pList $arANS(0,E)]
               set eE [expr $eB + 1]
            }
         } else {
            set FmT "%-21s%-19s%-20s%-5s %4d  %-s"
            set NeedSrc 0
            set pB 0 ; set pE 1
            set mB 0 ; set mE 1
            set eB 0 ; set eE 1
         }

         set fList ""
         for { set P $pB } { $P < $pE } { incr P } {
            for { set M $mB } { $M < $mE } { incr M } {
               for { set E $eB } { $E < $eE } { incr E } {
                  if $NeedSrc {
                     set U(E) [lindex $pList $E]
                     set dbF [file join $arANS(cSdir) Database $U(E).HD.DBF]
                  } else { 
                     set dbF [file join $arANS(cSdir) Database VIDF.I.DBF] 
                  }

                  DBdbfOpen $dbF dB

                  for { set I 0 } { $I < $dB(NumRecs) } { incr I } {
                     set ToRec [expr $dB(HLen) + $dB(RecLen) * $I ]
                     TUfileSeek $dB(fd) $ToRec start
                     set dBRec [read $dB(fd) $dB(RecLen)]
                     binary scan $dBRec aa8a4a3a8a4a3a8a10aaa2a3a8 \
                          Sp V bY bD bMs eY eD eMs fSize P1 cCode St aCode tM
                     set V [string trim $V]
                                                                                
                     set dtB [format "%4d%03d%08d" $bY $bD $bMs]
                     set dtE [format "%4d%03d%08d" $eY $eD $eMs]
                                                                                
                     if { [DBtimeCmp $dtB $dtE $bT $eT] != 0 } {
                        set bTm [format "%4d%03d%08d" $bY $bD $bMs]
                        set eTm [format "%4d%03d%08d" $eY $eD $eMs]
                        set Mn [expr int(($bMs % 3600000) / 60000 )]
                        set Hr [expr int($bMs / 3600000)]
                        set Tm [format "%4d%03d%02d%02d" $bY $bD $Hr $Mn]
                        if $NeedSrc {
                           lappend fList "$V$Tm $bTm $eTm $aCode $I $tM $U(E)"
                        } else { lappend fList "$V$Tm $bTm $eTm $aCode $I $tM" }
                     }
                  }
                  close $dB(fd)
               }
            }
         }

         set fList [lsort -ascii -increasing -index 1 $fList]

         set iLen [llength $fList]
         for { set J 0 } { $J < $iLen } { incr J  } {
            set fName [lindex [lindex $fList $J] 0]
            scan [lindex [lindex $fList $J] 1] "%4d%03d%08d" Yr Dy Ms]
            set Hr [expr int($Ms / 3600000)]
            set Mn [expr int(($Ms % 3600000) / 60000 )]
            set Sc [expr int($Ms / 1000 )]
            set bT [format "%4d/%03d %02d:%02d:%02d" $Yr $Dy $Hr $Mn $Sc]
            scan [lindex [lindex $fList $J] 2] "%4d%03d%08d" Yr Dy Ms]
            set Hr [expr int($Ms / 3600000)]
            set Mn [expr int(($Ms % 3600000) / 60000 )]
            set Sc [expr int($Ms / 1000 )]
            set eT [format "%4d/%03d %02d:%02d:%02d" $Yr $Dy $Hr $Mn $Sc]
            set aCode [lindex [lindex $fList $J] 3]
            set P     [lindex [lindex $fList $J] 4]
            set tM    [lindex [lindex $fList $J] 5]
            if $NeedSrc {
               set ExP [lindex [lindex $fList $J] 6]
               set LiNe [format $FmT $fName $bT $eT $aCode $ExP $P $tM]
            } else { set LiNe [format $FmT $fName $bT $eT $aCode $P $tM] }
            $W insert end $LiNe
         }
      }

      P  {
         set FmT "%-21s    %s    %s"
         set NeedSrc 0

         set cFg [file join $arANS(cSdir) ArchiveConfig]
         if [catch {open $cFg r} fd ] {
            puts stderr "AThdvpQuery: CANNOT OPEN $cFg"
            return 0
         }
                                                                                
         set aCode 0
         while { [gets $fd LiNe] > 0 } {
            set Flds [split $LiNe "|"]
            if [string match aCode [lindex $Flds 0] ] {
               set aCode [lindex $Flds 1]
               break
            }
         }
         close $fd

         SVreadACodes
         if ![info exists aCodeDir($aCode)] {
            puts stderr "AThdvpQuery: PIDF aCode $aCode unknown"
            return 0
         }

         set pList [exec $SySCmDs(ls) $aCodeDir($aCode)]
         set pLen  [llength $pList]
         set fList ""
         for { set I 0 } { $I < $pLen } { incr I } {  
            set pName [lindex $pList $I]
             if [string match pidf [lindex [split $pName "."] 1] ] {
                file stat [file join $aCodeDir($aCode) $pName] InFo
                set Tm [clock format $InFo(ctime) -format "%Y%m%d"]
                lappend fList "[file rootname $pName] $aCode $Tm"
             }
         }

         set fList [lsort -ascii -increasing -index 0 $fList]

         set iLen [llength $fList]
         for { set J 0 } { $J < $iLen } { incr J  } {
            set fName [lindex [lindex $fList $J] 0]
            set aCode [lindex [lindex $fList $J] 1]
            set tM   [lindex [lindex $fList $J] 2]
            set LiNe [format $FmT $fName $aCode $tM]
            $W insert end $LiNe
         }
      }
   }
}
