# PUTS up the hack statistics. 

package provide ArTool 1.0

proc ATassemStats { } {
   global asANS

   set Base  ""
   set asANS(Stats) ""
   set ipLen [llength $asANS(IP)] 

# LOOP over all of the transactions and build a set of statistical 
#    information 
# AN connect info list contains:
#   Index 0: the IP address
#   Index 1: the time of the initiation as YYYYDDDSSSSSSSS
#   Index 2: the request made
#   Index 3: the package sent if any
#   Index 4: the bytes sent set if any
#
# IGNORE AREUUP requests

   for { set I 0 } { $I < $ipLen } { incr I } {
      set ipInfo [lindex $asANS(IP) $I]
      set IP  [lindex $ipInfo 0]
      set ReQ [lindex $ipInfo 2]
      if [string match AREUUP $ReQ] { continue }
      if ![string match HACK $ReQ] {
         set HacK 0
         if { [lsearch $asANS(SendReq) $ReQ] < 0 } {
	    set Inq 1 ; set Send 0
         } else { set Inq 1 ; set Send 1 }
      } else { set HacK 1 ; set Send 0 ; set Inq 1 }
      set Bytes [lindex $ipInfo 4]

      set P [lsearch $Base $IP]
      if { $P < 0 } {
         lappend Base $IP
         lappend asANS(Stats) [list $IP $HacK $Inq $Send $Bytes]
      } else {
         set cInfo [lindex $asANS(Stats) $P]
	 set nH [expr [lindex $cInfo 1] + $HacK] 
	 set nI [expr [lindex $cInfo 2] + $Inq] 
	 set nS [expr [lindex $cInfo 3] + $Send] 
	 set nB [expr [lindex $cInfo 4] + $Bytes] 
         set cInfo [list $IP $nH $nI $nS $nB]
	 set asANS(Stats) [lreplace $asANS(Stats) $P $P $cInfo]
      }
   }
}
