package provide ArTool 1.0

proc ATacodeAdd { } {
   global acANS env logW

# CHECK that all the information is there

   if ![ATvarCheck ACODE acANS] return
                                                                                
# UPDATE the ArchiveInfo file.  This may entail creating  both it and the 
#    directory in which it resides.

# INITIALIZE NoFile flag to indicate that the file we are after is not on the
#   the system

   set NoFile 1

# SEE what exists and create what doesn't

   if [info exists env(UDF_HOME)] {
      set aDir [file join $env(UDF_HOME) Archives]
      set Fname [file join $aDir ArchiveInfo]
      if [file exists $Fname] { set NoFile 0 }
   } else {
      lappend Msg "ENVIRONMENT variable UDF_HOME does not exist"
      lappend Msg "MUST be set prior to updating the ArchiveInfo file"
      GUImsgPopUp .ewin -1 -1 $Msg
      return -1
   } 

# IF we didn't find a file present then create the skeleton file.  This may
#   require creating the directory its in also.

   set LFmt "%-14s %s"
   if $NoFile {
      if ![file isdirectory $env(UDF_HOME)]  {
         $logW insert end "CREATING directory $env(UDF_HOME)\n"
         file mkdir $env(UDF_HOME)
      }
      if ![file isdirectory $aDir]  {
         $logW insert end "CREATING directory $aDir\n"
         file mkdir $aDir
      }

      if [catch {open $Fname w} fd] {
         $logW insert end "UNABLE TO CREATE $Fname\n"
         $logW insert end "   You might need run as root.\n"
         return
      }

      $logW insert end "CREATING skeleton ArchiveInfo File\n"
      puts $fd [format $LFmt "Archive Code" "Data Location"]
      puts $fd [format $LFmt "------------" "-------------"]
      close $fd
   }

   if [catch {open $Fname a} fd] {
      $logW insert end "UNABLE TO CREATE $Fname\n"
      $logW insert end "   You might need run as root.\n"
      return
   }

   $logW insert end "UPDATING ArchiveInfo File\n"
   puts $fd [format $LFmt $acANS(aCode) $acANS(sDir)]
   close $fd
   if [winfo exists .sWin] {
     .sWin.mid.log insert end [format $LFmt $acANS(aCode) $acANS(sDir)]
   }

# CREATE archive directory.  

   if ![file isdirectory $acANS(sDir)]  {
      $logW insert end "Archive directory $acANS(sDir) Created\n"
      file mkdir $acANS(sDir)
   } else { $logW insert end "Archive directory $acANS(sDir) Exists\n" }
}
