# THIS procedure sends the requested UDF file if it can be found.  
#    The requested file must first pass a validity check which is simply 
#    that it must be in a recognized archive data directory. 

package provide Server 1.0

proc SVudfSend { sock LiNe } {
   global DonE sCFG

#  GET the file directory and then verify that it is one of the archive
#     directories recognized by the server.

   set fDir [lindex $LiNe 1]
   set Stat [SVudfVerify $LiNe]

#  IF we pass verification then we can send the data.  Need to log the
#    the send if there is a log file. 
#
#  IF we didn't pass verification log the request as a HACK attempt

   if { $Stat == 1 } {
      set fName [lindex $LiNe 2]
      set SeNd [file join $fDir $fName]
      if [catch {open $SeNd r} fd ] {
         puts $sCFG(lfd) "SVudfSend:  CANNOT OPEN FILE $SeNd"
         return 1
      }

      set Home [fconfigure $sock -sockname] 
      set Away [fconfigure $sock -peername] 
      if [string match YES $sCFG(log)] {
         puts -nonewline $sCFG(lfd) "([lindex $Home 0]/[lindex $Home 2]) \
                     Sending $fName to [lindex $Away 0]/[lindex $Away 2] \
                     at [clock format [clock seconds]] "
         flush $sCFG(lfd)
      }

      fconfigure $fd -translation binary
      fconfigure $sock -translation binary
      fcopy $fd $sock -command [list SVsendClose $fd ]
      vwait DonE 
      if [info exists DonE] { unset DonE }
   } else {
      set Away [fconfigure $sock -peername] 
      if [string match YES $sCFG(log)] {
          puts $sCFG(lfd) "HACK TRY - Src: [lindex $Away 0]/[lindex $Away 2] \
                           Requesting: [lindex $LiNe 1] [lindex $LiNe 2]"
          flush $sCFG(lfd)
      }
   }
}
