# THIS procedure recreates the software database.
#
# INPUTS:
#   sWdB - the name of the software database   
#   dBF - the database fields. 
#   dBE - the database entries. 

package provide Server 1.0

proc SVswdbWrite { sWdB dBF dBE } {
   global sCFG

   upvar $dBE sW

# IF the database does not exist then create it if the create flag is 1
#   or just return a 1 indicating that the database does not exist

   if [catch {open $sWdB w} fd ] {
      set TiMe [clock format [clock seconds] -format "%c"]
      puts $sCFG(efd) "$TiMe: CANNOT CREATE Database file $dbF"
      flush $sCFG(efd)
      return -1
   }
   set fLen [llength $dBF]
   set fL "Fields: [lindex $dBF 0]"
   for { set I 1 } { $I < $fLen } { incr I } { append fL +[lindex $dBF $I] }

   puts $fd $fL

   set nF [llength $sW(PKG)]
   if { $nF == 0 } { return }
   for { set I 0 } { $I < $nF } { incr I } {
      puts $fd "PKG  [lindex $sW(PKG) $I]"
      for { set J 0 } { $J < $fLen } { incr J } {
         set FlD [lindex $dBF $J]
         if ![string match PKG $FlD] {
            set Entry [lindex $sW($FlD) $I]
            if { [string length $Entry] > 0 } {
               puts $fd [format "%-5s   %s" $FlD $Entry]
            }
         }
      }
   }
   
   close $fd
   return 1
} 
