# THIS procedure reads the software database.
#
# INPUTS:
#   sWdB - the name of the software database   
#   Cr   - 1 if there is no database - create it
#
# OUTPUTS:
#   dBEntries - the software database entries.  This is an array variable.  
#               Each array element is a list of the database entries for 
#               one of the database entry fields

package provide Server 1.0

proc SVswdbRead { sWdB dBFields dBEntries { Cr 1 } } {
   global sCFG

   upvar $dBEntries sW
   upvar $dBFields  fL

# IF the database does not exist then create it if the create flag is 1
#   or just return a 1 indicating that the database does not exist

   if ![file exists $sWdB] { 
      if $Cr { 
         if [catch {open $sWdB w} fd ] {
            set TiMe [clock format [clock seconds] -format "%c"]
            puts $sCFG(efd) "$TiMe: CANNOT CREATE Database file $dbF"
            flush $sCFG(efd)
            return -1
         }
         puts $fd "FIELDS: PKG+REV+DIR+OPT+ENV+DEP+SCMD+RCMP+TIME+ACODE"
         close $fd
      } else { return 0 }
   } 

# FIRST make sure that we can open the file containing the information

   if [catch {open $sWdB r} fd ] {
      set TiMe [clock format [clock seconds] -format "%c"]
      puts $sCFG(efd) "$TiMe: CANNOT OPEN $sWdB"
      flush $sCFG(efd)
      exit
   }

# READ the field information.  This says what fields may be defined in a 
#   given package definition

   gets $fd LiNe
   scan $LiNe "%s %s" TmP fList
   set fL [split $fList +]
   set fLen [llength $fL]
   for { set I 0 } { $I < $fLen } { incr I } { set sW([lindex $fL $I]) "" }

# READ the information.  It is stored as a set of lists in sWFname

    set Here(PKG) 0
    while { [gets $fd LiNe] >= 0 } {
       scan $LiNe "%s %s" Fld Entry
       set Fld [string trim $Fld]
       set Entry [string trim $Entry]
       if [string match PKG $Fld] {
          if $Here(PKG) {
             for { set I 0 } { $I < $fLen } { incr I } {
                if !$Here([lindex $fL $I]) { 
                   lappend sW([lindex $fL $I]) ""
                }
             }
          }
          for { set I 0 } { $I < $fLen } { incr I } {
             set Here([lindex $fL $I]) 0
          }
       }

       set Here($Fld) 1
       lappend sW($Fld) $Entry
    }

    close $fd
    return 1
} 
