# THIS procedure reads the software database.
#
# INPUTS:
#   sWdB - the name of the software database   
#
# OUTPUTS:
#   dBEntries - the software database entries.  This is an array variable.  
#               Each array element is a list of the database entries for 
#               one of the database entry fields
#
# RETURNS:  The database name

package provide Server 1.0

proc SVswdbEntry { dBEntry dBInfo } {
   global sCFG

   upvar $dBInfo sW

# FIRST make sure that we can open the file containing the information

   if [catch {open $dBEntry r} fd ] {
      set TiMe [clock format [clock seconds] -format "%c"]
      puts $sCFG(efd) "$TiMe: CANNOT OPEN $dBEntry"
      flush $sCFG(efd)
      return ""
   }

# READ the field information.  This says what fields may be defined in a 
#   given package definition

    while { [gets $fd LiNe] >= 0 } {
       scan $LiNe "%s %s" Fld Entry
       set Fld [string trim $Fld]
       set Entry [string trim $Entry]
       set sW($Fld) $Entry
    }

    close $fd
 
# FORM the database name

    if [info exists sW(DIR)] {
       set HoMe [lindex [split $sW(DIR) "+"] 0] 
       switch -exact -- $HoMe {
          UDFTOOL_HOME  { set dbName uTools.db }
          TCLTOOLS_HOME { set dbName tTools.db }
          UDF_HOME      { set dbName udf.db    }
          GPH_HOME      { set dbName gph.db    }
          IDLTOOLS_HOME { set dbName iTools.db }
          UDFDOC_HOME   { set dbName uDoc.db }
       }
    } else { set dbName "" }

   return $dbName
} 
