# THIS procedure returns a software package to the client.

package provide Server 1.0

proc SVswSend { sock LiNe } {
   global sDEF aCodeDir DonE sCFG

#  THIS is the archive iD

   set iD software
   set port [lindex $LiNe end]

# FIND the directory which contains the archive databases
                                                                                
   set aDir ""
   for { set I 0 } { $I < $sDEF(aN) } { incr I } {
      if { [string match $iD $sDEF($I,iD)] && ($port == $sDEF($I,Port)) } {
         set aDir $sDEF($I,aDir)
         break
      }
   }

# THIS is the database file

   set db [file join $aDir Database [lindex $LiNe 3].db] 

# THIS is the type of package

   set FmT [lindex $LiNe 4] 
   if [string match 0 $FmT] { set FmT SRC }

# READ the database.  If we can't then we are done here

   set Status [SVswdbSearch $db [lindex $LiNe 1] [lindex $LiNe 2] dbF dbE]
   if { [lindex $Status 0] == 1 } {
      set PoS [lindex $Status 1]
      set pDir  $aCodeDir([lindex $dbE(ACODE) $PoS])
      if [string match SRC $FmT] {
         set pName [lindex $LiNe 1].[lindex $dbE(REV) $PoS].tar
      } else { 
         set pName [lindex $LiNe 1].[lindex $dbE(REV) $PoS].$FmT.tar 
         set pSend [file join $pDir $pName]
         if ![file exists $pSend] {
            set pName [lindex $LiNe 1].[lindex $dbE(REV) $PoS].tar 
         }
      }

      set pSend [file join $pDir $pName]
      
# MAKE sure package exists

      if ![file exists $pSend] {
         set TiMe [clock format [clock seconds] -format "%c"]
         puts $sCFG(lfd) "SVswSend:  FILE $pSend does not exist"
         puts $sCFG(efd) "$TiMe: SVswSend:  FILE $pSend does not exist"
	 flush $sCFG(lfd)
	 flush $sCFG(efd)
         return 0
      }

# OPEN the package and ship it off

      if [catch {open $pSend r} fd ] {
         puts $sCFG(lfd) "SVswSend:  CANNOT OPEN FILE $pSend"
         set TiMe [clock format [clock seconds] -format "%c"]
         puts $sCFG(efd) "$TiMe: SVswSend:  CANNOT OPEN FILE $pSend"
	 flush $sCFG(lfd)
	 flush $sCFG(efd)
         return 0
      }
                                                                               
      set Home [fconfigure $sock -sockname]
      set Away [fconfigure $sock -peername]
      if [string match YES $sCFG(log)] {
         puts -nonewline $sCFG(lfd) "([lindex $Home 0]/[lindex $Home 2]) \
                     Sending $pName to [lindex $Away 0]/[lindex $Away 2] \
                     at [clock format [clock seconds]] "
         flush $sCFG(lfd)
      }
                                                                               
      fconfigure $fd -translation binary
      fconfigure $sock -translation binary
      fcopy $fd $sock -command [list SVsendClose $fd ]
      vwait DonE
      if [info exists DonE] { unset DonE }
   }

   return 1
} 
