# THIS procedure determines what the request is and then processes it.
#   Each request is a simple list with the first entry in the list 
#   providing what the list contains and therefore what needs to be done.
#   Recognized actions are:
#      SEARCH:   The server is being asked to search for data from a
#                given UDF defintion within a specified time period.
#                The following list elements are:
#                    Project    - UDF project acronym
#                    Mission    - UDF mission acronym
#                    Experiment - UDF experiment acronym
#                    Instrument - UDF instrument acronym
#                    Virtual    - UDF virtual instrument acronym
#                    BYear      - Start year of data
#                    BDay       - Start day or data
#                    BMsec      - Start milliseconds of data
#                    EYear      - End year of data
#                    EDay       - End day or data
#                    EMsec      - End milliseconds of data
#                    Status     - Pop Up Status window Flag
#      UDF:      The server is being asked to send a UDF HEADER or DATA file 
#                The following list elements are:
#                    Dir        - Directory of data
#                    File       - Data file name 
#      DBLIST:   The server is being asked to send its list of databases
#      PKGNAMES: The server is being asked to send a software database
#                    dbName    - database name (uTools tTools iTools udf etc)
#                    Status   - Pop Up Status window Flag
#      PKGSEND:  The server is being asked to send a software package
#                The following list elements are:
#                    PkG     - The base package name 
#                    ReV     - The package revision 
#                    dbName  - The base database name
#                    Status  - Pop Up Status window Flag

package provide Server 1.0

proc SVreqRead { sock iP iPP } {
  global ReqCh sCFG

#  IF the socket is not closed read the current line.  This should be the
#     request list. 

   if { [eof $sock] || [ catch { gets $sock LiNe } ] } {
      if [catch { close $sock } OuT] { 
         set TiMe [clock format [clock seconds] -format "%c"]
         puts $sCFG(efd) "$TiMe: $OuT" 
	 flush $sCFG(efd)
      }
      if [info exists ReqCh(addr,$sock)] { unset ReqCh(addr,$sock) }
   } else {

      if [string match YES $sCFG(log)] {
         puts $sCFG(lfd) "$iP port $iPP [lindex $LiNe 0]"
         flush $sCFG(lfd)
      }

      set AcTioN [lindex $LiNe 0]
      switch -exact -- $AcTioN {
         SEARCH   { SVdbSearch $sock $LiNe HD }
         SEARCHV  { SVdbSearch $sock $LiNe I  }
         SEARCHP  { SVpidfSearch $sock $LiNe  }
         PIDF     { SVudfSend $sock $LiNe  }
         UDF      { SVudfSend $sock $LiNe  }
         VIDF     { SVudfSend $sock $LiNe  }
         PKGNAMES { SVswdbSend $sock $LiNe }
         PKGSEND  { SVswSend $sock $LiNe }
         DBLIST   { SVdblistSend $sock $LiNe }
         AREUUP   { SVupSend $sock $LiNe }
      }

      if [catch { close $sock } OuT] { 
         set TiMe [clock format [clock seconds] -format "%c"]
         puts $sCFG(efd) "$TiMe: $OuT" 
	 flush $sCFG(efd)
      }
      if [info exists ReqCh(addr,$sock)] { unset ReqCh(addr,$sock) }
   }
}
