# THIS procedure accepts a request from a client and files the request
#   into the server log if one is being kept.

package provide Server 1.0

proc SVreqAccept { sock addr port } {
   global ReqCh sCFG 

   if [string match YES $sCFG(log)] {
      set Home [fconfigure $sock -sockname] 
      puts $sCFG(lfd) "([lindex $Home 0]/[lindex $Home 2]) \
                     Accepted $sock from $addr port $port \
                     [clock format [clock seconds]]"
      flush $sCFG(lfd)
   }

   set ReqCh(addr,$sock) [list $addr $port]
   fconfigure $sock -buffering line
   fileevent $sock readable [list SVreqRead $sock $addr $port ]
}
