#  THIS procedure reads in the archive codes and stores them in an
#    array aCodeDir.  The archive codes form the array indices and 
#    the array element is set to the corresponding directory.

package provide Server 1.0

proc SVreadACodes {  } {
   global env aCodeDir sCFG

# THE full path to the ArchiveInfo file is:

   set fName [file join $env(UDF_HOME) Archives ArchiveInfo]

# OPEN the file - abort program if we can't open it.

   if [catch {open $fName r} fd] {
      set TiMe [clock format [clock seconds] -format "%c"]
      puts $sCFG(efd) "$TiMe: ERROR: UNABLE TO OPEN ArchiveInfo FILE: $fName"
      flush $sCFG(efd)
      exit
   }

# FIRST two lines of file are comments

   gets $fd LiNe
   gets $fd LiNe

# THE rest are the defined archive codes

  while { [gets $fd LiNe] >= 0 } {
     scan $LiNe "%s %s" aC aD
     set aCodeDir($aC) $aD
  }
   
  close $fd
}
