# THIS procedure converts the UDF files into the native integer format of
#   the host system (little endian or big endian).

package provide Server 1.0

proc SVhdNative { aDir ManiFest } {
   global env tcl_platform sCFG 

# THIS is the directory where the incoming files are found

   set dDir [file join $aDir Incoming]

# THIS is the directory where the VIDF files are found.  These are needed
#   when converting the data.

   set vDir [file join $aDir VIDFS]

# LOOP over the UDF files being transferred into the archive 

   set mLen [llength $ManiFest]
   for { set I 0 } { $I < $mLen } { incr I } {

# GET the base filename and form the header/data filenames from it 

      set BaseName [lindex [lindex $ManiFest $I] 0]
      set hF [file join $dDir ${BaseName}H]
      set dF [file join $dDir ${BaseName}D]

# FIND the VIDF file which corresponds to this file.  vName is the UDF
#   virtual instrument to which the file belongs.  Should multiple VIDF's
#   be found just use the first one.

      set bLen [string length $BaseName]
      set vName [string range $BaseName 0 [expr $bLen - 12]]
      set vFiles [DBvidfFind $vDir $vName ]
      if {[string length $vFiles] == 0 } {
         set TiMe [clock format [clock seconds] -format "%c"]
         puts $sCFG(efd) "$TiMe: NO VIDF file for $BaseName!!"
	 flush $sCFG(efd)
         continue 
      } 
      set vF [file join $vDir [lindex $vFiles 0]]

# GET the data into native integer format.  The routine will do nothing if
#   the data is already in native format.

      DBautoSwap $vF $hF $dF
   }
}
