# THIS procedure removes all of the entries from the archive database(s) which
#    are contained in the list rmList
#
#   INPUTS are:
#      aDir     - the archive base directory
#      rmList   - the list of entries to be removed.  Each list entry is a
#                 list containing the entry UDF experiment and the entry 
#                 key.  The experiment provides the database name.

package provide Server 1.0

proc SVdbfRemove { aDir rmList { dType HD } } {
   global env tcl_platform 
           
# HOW many entries are we removing?

   set rLen [llength $rmList]
   if { $rLen == 0 } { return }

# SINCE the databases are formed per EXPERIMENT, order the list by the
#   experiment so that we can remove all the database entries in a single 
#   database at one time

   set rmList [lsort -ascii -increasing -index 0 $rmList]

# INITIALIZE the path to the first database and the current experiment
#   and the remove list

   set rmPos ""
   set CurExp [lindex [lindex $rmList 0] 0]
   for { set I 0 } { $I < $rLen } { incr I } {
      set ExP [lindex [lindex $rmList $I] 0]
      if [string match $ExP $CurExp] {
         lappend rmPos [lindex [lindex $rmList $I] 1]
      } else {
         set dB [file join $aDir Database $CurExp.$dType.DBF]
         DBdbfDelete $dB $rmPos
         set rmPos [lindex [lindex $rmList $I] 1]
         set CurExp $ExP
      }
   }

# DELETE the last group of files

   set dB [file join $aDir Database $CurExp.$dType.DBF]
   DBdbfDelete $dB $rmPos
}
